/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.elasticutils.elasticsearch7.client;

import de.bytefish.elasticutils.client.IElasticSearchClient;
import de.bytefish.elasticutils.elasticsearch7.client.bulk.configuration.BulkProcessorConfiguration;
import de.bytefish.elasticutils.elasticsearch7.mapping.IElasticSearchMapping;
import de.bytefish.elasticutils.utils.JsonUtilities;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentType;

public class ElasticSearchClient<TEntity>
implements IElasticSearchClient<TEntity> {
    private final RestHighLevelClient client;
    private final String indexName;
    private final IElasticSearchMapping mapping;
    private final BulkProcessor bulkProcessor;

    public ElasticSearchClient(RestHighLevelClient client, String indexName, IElasticSearchMapping mapping, BulkProcessorConfiguration bulkProcessorConfiguration) {
        this.client = client;
        this.indexName = indexName;
        this.mapping = mapping;
        this.bulkProcessor = bulkProcessorConfiguration.build(client);
    }

    public void index(TEntity entity) {
        this.index(Arrays.asList(entity));
    }

    public void index(List<TEntity> entities) {
        this.index(entities.stream());
    }

    public void index(Stream<TEntity> entities) {
        entities.map(x -> JsonUtilities.convertJsonToBytes((Object)x)).filter(x -> x.isPresent()).map(x -> this.createIndexRequest((byte[])x.get())).forEach(arg_0 -> ((BulkProcessor)this.bulkProcessor).add(arg_0));
    }

    private IndexRequest createIndexRequest(byte[] messageBytes) {
        IndexRequest request = new IndexRequest();
        request.index(this.indexName);
        request.source((BytesReference)new BytesArray(messageBytes), XContentType.JSON);
        return request;
    }

    public void flush() {
        this.bulkProcessor.flush();
    }

    public synchronized boolean awaitClose(long timeout, TimeUnit unit) throws InterruptedException {
        return this.bulkProcessor.awaitClose(timeout, unit);
    }

    public void close() throws Exception {
        this.bulkProcessor.close();
    }
}

