/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.elasticutils.elasticsearch7.client.bulk.configuration;

import de.bytefish.elasticutils.elasticsearch7.client.bulk.listener.LoggingBulkProcessorListener;
import de.bytefish.elasticutils.elasticsearch7.client.bulk.options.BulkProcessingOptions;
import de.bytefish.elasticutils.elasticsearch7.client.bulk.options.BulkProcessingOptionsBuilder;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;

public class BulkProcessorConfiguration {
    private BulkProcessingOptions options = new BulkProcessingOptionsBuilder().build();
    private BulkProcessor.Listener listener = new LoggingBulkProcessorListener();

    public BulkProcessorConfiguration(BulkProcessingOptions options) {
        this(options, new LoggingBulkProcessorListener());
    }

    public BulkProcessorConfiguration(BulkProcessingOptions options, BulkProcessor.Listener listener) {
        this.options = options;
        this.listener = listener;
    }

    public BulkProcessingOptions getBulkProcessingOptions() {
        return this.options;
    }

    public BulkProcessor.Listener getBulkProcessorListener() {
        return this.listener;
    }

    public BulkProcessor build(RestHighLevelClient client) {
        return BulkProcessor.builder((request, bulkListener) -> client.bulkAsync(request, RequestOptions.DEFAULT, bulkListener), (BulkProcessor.Listener)this.listener).setConcurrentRequests(this.options.getConcurrentRequests()).setBulkActions(this.options.getBulkActions()).setBulkSize(this.options.getBulkSize()).setFlushInterval(this.options.getFlushInterval()).setBackoffPolicy(this.options.getBackoffPolicy()).build();
    }
}

