/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.elasticutils.elasticsearch7.client.bulk.listener;

import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.common.logging.Loggers;

public class LoggingBulkProcessorListener
implements BulkProcessor.Listener {
    private static final Logger log = Loggers.getLogger(LoggingBulkProcessorListener.class, (String[])new String[]{LoggingBulkProcessorListener.class.getName()});

    public void beforeBulk(long executionId, BulkRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("ExecutionId = {}, Actions = {}, Estimated Size = {}", (Object)executionId, (Object)request.numberOfActions(), (Object)request.estimatedSizeInBytes());
        }
    }

    public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
        if (log.isDebugEnabled()) {
            log.debug("ExecutionId = {}, Actions = {}, Estimated Size = {}", (Object)executionId, (Object)request.numberOfActions(), (Object)request.estimatedSizeInBytes());
        }
    }

    public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
        if (log.isErrorEnabled()) {
            log.error("ExecutionId = {}, Error = {}", (Object)executionId, (Object)failure);
        }
    }
}

