/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.elasticutils.elasticsearch7.utils;

import de.bytefish.elasticutils.elasticsearch7.exceptions.GetMappingsRequestFailedException;
import de.bytefish.elasticutils.elasticsearch7.mapping.IElasticSearchMapping;
import de.bytefish.elasticutils.exceptions.CreateIndexFailedException;
import de.bytefish.elasticutils.exceptions.IndicesExistsFailedException;
import de.bytefish.elasticutils.exceptions.PutMappingFailedException;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;

public class ElasticSearchUtils {
    private static final Logger log = Loggers.getLogger(ElasticSearchUtils.class, (String[])new String[]{ElasticSearchUtils.class.getName()});

    private ElasticSearchUtils() {
    }

    public static boolean indexExist(RestHighLevelClient client, String indexName) {
        try {
            GetIndexRequest request = new GetIndexRequest(new String[]{indexName});
            return client.indices().exists(request, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error Checking Index Exist", (Throwable)e);
            }
            throw new IndicesExistsFailedException(indexName, (Throwable)e);
        }
    }

    public static boolean mappingsExist(RestHighLevelClient client, String indexName) {
        try {
            GetMappingsRequest request = new GetMappingsRequest().indices(new String[]{indexName});
            GetMappingsResponse response = client.indices().getMapping(request, RequestOptions.DEFAULT);
            return ElasticSearchUtils.responseContainsMappings(response);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error Getting Mappings", (Throwable)e);
            }
            throw new GetMappingsRequestFailedException(indexName, e);
        }
    }

    private static boolean responseContainsMappings(GetMappingsResponse response) {
        Map result = response.mappings();
        if (result == null) {
            return false;
        }
        return !result.isEmpty();
    }

    public static CreateIndexResponse createIndex(RestHighLevelClient client, String indexName) {
        try {
            return ElasticSearchUtils.internalCreateIndex(client, indexName);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error Creating Index", (Throwable)e);
            }
            throw new CreateIndexFailedException(indexName, (Throwable)e);
        }
    }

    public static void createOrUpdatemapping(RestHighLevelClient client, String indexName, IElasticSearchMapping mapping) {
        if (ElasticSearchUtils.mappingsExist(client, indexName)) {
            ElasticSearchUtils.updateMapping(client, indexName, mapping);
        } else {
            ElasticSearchUtils.putMapping(client, indexName, mapping);
        }
    }

    public static AcknowledgedResponse putMapping(RestHighLevelClient client, String indexName, IElasticSearchMapping mapping) {
        try {
            return ElasticSearchUtils.internalPutMapping(client, indexName, mapping);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error Creating Index", (Throwable)e);
            }
            throw new PutMappingFailedException(indexName, (Throwable)e);
        }
    }

    public static AcknowledgedResponse updateMapping(RestHighLevelClient client, String indexName, IElasticSearchMapping mapping) {
        try {
            return ElasticSearchUtils.internalUpdateMapping(client, indexName, mapping);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error Updating Index", (Throwable)e);
            }
            throw new PutMappingFailedException(indexName, (Throwable)e);
        }
    }

    private static CreateIndexResponse internalCreateIndex(RestHighLevelClient client, String indexName) throws IOException {
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        CreateIndexResponse response = client.indices().create(request, RequestOptions.DEFAULT);
        if (log.isDebugEnabled()) {
            log.debug("CreatedIndexResponse: isAcknowledged {}", (Object)response.isAcknowledged());
        }
        return response;
    }

    private static AcknowledgedResponse internalPutMapping(RestHighLevelClient client, String indexName, IElasticSearchMapping mapping) throws IOException {
        String json = Strings.toString((XContentBuilder)mapping.getMapping());
        PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{indexName}).source(json, XContentType.JSON);
        AcknowledgedResponse putMappingResponse = client.indices().putMapping(putMappingRequest, RequestOptions.DEFAULT);
        if (log.isDebugEnabled()) {
            log.debug("PutMappingResponse: isAcknowledged {}", (Object)putMappingResponse.isAcknowledged());
        }
        return putMappingResponse;
    }

    private static AcknowledgedResponse internalUpdateMapping(RestHighLevelClient client, String indexName, IElasticSearchMapping mapping) throws IOException {
        Map<String, Object> objectMap = ElasticSearchUtils.convertToMap(mapping);
        Map innerMap = (Map)objectMap.get(mapping.getIndexType());
        PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{indexName}).source(innerMap);
        AcknowledgedResponse putMappingResponse = client.indices().putMapping(putMappingRequest, RequestOptions.DEFAULT);
        if (log.isDebugEnabled()) {
            log.debug("PutMappingResponse: isAcknowledged {}", (Object)putMappingResponse.isAcknowledged());
        }
        return putMappingResponse;
    }

    private static Map<String, Object> convertToMap(IElasticSearchMapping mapping) {
        XContentBuilder xContentBuilder = mapping.getMapping();
        return (Map)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)xContentBuilder), (boolean)true, (XContentType)xContentBuilder.contentType()).v2();
    }
}

