/*
 * Decompiled with CFR 0.152.
 */
package de.carne.boot;

import de.carne.boot.ApplicationJarURLStreamHandlerFactory;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.eclipse.jdt.annotation.NonNull;

public final class ApplicationJarClassLoader
extends URLClassLoader {
    public ApplicationJarClassLoader(File jarFile, ClassLoader parent) throws IOException {
        this(jarFile, new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, parent));
    }

    private ApplicationJarClassLoader(File jarFile, URLClassLoader jarLoader) throws IOException {
        super(ApplicationJarClassLoader.assembleExternalJarClasspath(jarFile, jarLoader), (ClassLoader)jarLoader);
    }

    ApplicationJarClassLoader(JarURLConnection inlineJarConnection, ClassLoader parent) throws IOException {
        super(ApplicationJarClassLoader.assembleInlineJarClasspath(inlineJarConnection, parent), parent);
    }

    private static URL[] assembleInlineJarClasspath(JarURLConnection jarConnection, ClassLoader jarLoader) throws IOException {
        List<String> jarJars;
        try (Stream<JarEntry> jarEntries = jarConnection.getJarFile().stream();){
            jarJars = jarEntries.filter(entry -> entry.getName().endsWith(".jar")).map(ZipEntry::getName).collect(Collectors.toList());
        }
        return ApplicationJarClassLoader.assembleClasspath(jarJars, jarLoader);
    }

    private static URL[] assembleExternalJarClasspath(File file, ClassLoader jarLoader) throws IOException {
        List<String> jarJars;
        try (JarFile jarFile = new JarFile(file);
             Stream<JarEntry> jarEntries = jarFile.stream();){
            jarJars = jarEntries.filter(entry -> entry.getName().endsWith(".jar")).map(ZipEntry::getName).collect(Collectors.toList());
        }
        return ApplicationJarClassLoader.assembleClasspath(jarJars, jarLoader);
    }

    private static URL[] assembleClasspath(List<@NonNull String> jarJars, ClassLoader jarLoader) throws IOException {
        URL[] classpath = new URL[jarJars.size()];
        if (classpath.length > 0) {
            ApplicationJarURLStreamHandlerFactory jarShf = new ApplicationJarURLStreamHandlerFactory(jarLoader);
            int classpathIndex = 0;
            for (String jarJar : jarJars) {
                classpath[classpathIndex] = jarShf.getJarJarUrl(jarJar);
                ++classpathIndex;
            }
        }
        return classpath;
    }

    static {
        ApplicationJarClassLoader.registerAsParallelCapable();
    }
}

