/*
 * Decompiled with CFR 0.152.
 */
package de.carne.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.function.IntFunction;
import org.eclipse.jdt.annotation.Nullable;

public class AnsiFilter
extends FilterWriter {
    private State state = State.STANDARD;

    public AnsiFilter(Writer out) {
        super(out);
    }

    @Override
    public void write(int c) throws IOException {
        this.state = this.state.apply(c);
        if (this.state == State.STANDARD) {
            super.write(c);
        } else if (this.state == State.UNKNOWN_ESC) {
            super.write(27);
            super.write(c);
            this.state = State.STANDARD;
        }
    }

    @Override
    public void write(char @Nullable [] cbuf, int off, int len) throws IOException {
        if (cbuf != null) {
            boolean standardState = this.state == State.STANDARD;
            int writeOff1 = off;
            int offLimit = off + len;
            for (int writeOff2 = off; writeOff2 < offLimit; ++writeOff2) {
                char c = cbuf[writeOff2];
                this.state = this.state.apply(c);
                if (this.state == State.STANDARD) {
                    if (standardState) continue;
                    writeOff1 = writeOff2;
                    standardState = true;
                    continue;
                }
                if (this.state == State.UNKNOWN_ESC) {
                    super.write(27);
                    this.state = State.STANDARD;
                    writeOff1 = writeOff2;
                    standardState = true;
                    continue;
                }
                if (standardState) {
                    if (writeOff1 < writeOff2) {
                        super.write(cbuf, writeOff1, writeOff2 - writeOff1);
                        writeOff1 = writeOff2;
                    }
                    ++writeOff1;
                    standardState = false;
                    continue;
                }
                ++writeOff1;
            }
            if (standardState && writeOff1 < offLimit) {
                super.write(cbuf, writeOff1, offLimit - writeOff1);
            }
        } else {
            super.write(cbuf, off, len);
        }
    }

    @Override
    public void write(@Nullable String str, int off, int len) throws IOException {
        if (str != null) {
            boolean standardState = this.state == State.STANDARD;
            int writeOff1 = off;
            int offLimit = off + len;
            for (int writeOff2 = off; writeOff2 < offLimit; ++writeOff2) {
                char c = str.charAt(writeOff2);
                this.state = this.state.apply(c);
                if (this.state == State.STANDARD) {
                    if (standardState) continue;
                    writeOff1 = writeOff2;
                    standardState = true;
                    continue;
                }
                if (this.state == State.UNKNOWN_ESC) {
                    super.write(27);
                    this.state = State.STANDARD;
                    writeOff1 = writeOff2;
                    standardState = true;
                    continue;
                }
                if (standardState) {
                    if (writeOff1 < writeOff2) {
                        super.write(str, writeOff1, writeOff2 - writeOff1);
                        writeOff1 = writeOff2;
                    }
                    ++writeOff1;
                    standardState = false;
                    continue;
                }
                ++writeOff1;
            }
            if (standardState && writeOff1 < offLimit) {
                super.write(str, writeOff1, offLimit - writeOff1);
            }
        } else {
            super.write(str, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.state == State.ESC) {
            super.write(27);
            this.state = State.STANDARD;
        }
        super.flush();
    }

    private static enum State {
        STANDARD(State::standardState),
        ESC(State::escState),
        UNKNOWN_ESC(State::finalState),
        CSI(State::csiOrParameterState),
        PARAMETER(State::csiOrParameterState),
        INTERMEDIATE(State::intermediateState),
        FINAL(State::finalState);

        private final IntFunction<State> transition;

        private State(IntFunction<State> transition) {
            this.transition = transition;
        }

        private static State standardState(int c) {
            return c == 27 ? ESC : STANDARD;
        }

        private static State escState(int c) {
            return c == 155 ? CSI : UNKNOWN_ESC;
        }

        private static State csiOrParameterState(int c) {
            return 48 <= c && c <= 63 ? PARAMETER : State.intermediateState(c);
        }

        private static State intermediateState(int c) {
            return 32 <= c && c <= 47 ? INTERMEDIATE : (64 <= c && c <= 127 ? FINAL : STANDARD);
        }

        private static State finalState(int c) {
            return STANDARD;
        }

        public State apply(int c) {
            return this.transition.apply(c);
        }
    }
}

