/*
 * Decompiled with CFR 0.152.
 */
package de.carne.io;

import de.carne.io.Checksum;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jdt.annotation.Nullable;

public class ChecksumOutputStream
extends FilterOutputStream {
    private final Checksum checksum;

    public ChecksumOutputStream(OutputStream out, Checksum checksum) {
        super(out);
        this.checksum = checksum;
    }

    public byte[] getChecksumValue() {
        return this.checksum.getValue();
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.checksum.update((byte)b);
    }

    @Override
    public void write(byte @Nullable [] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte @Nullable [] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.checksum.update(b, off, len);
    }
}

