/*
 * Decompiled with CFR 0.152.
 */
package de.carne.io;

import de.carne.io.Defaults;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public final class IOUtil {
    private IOUtil() {
    }

    public static long copyStream(OutputStream dst, InputStream src) throws IOException {
        long copied;
        block13: {
            if (dst instanceof FileOutputStream && src instanceof FileInputStream) {
                try (FileChannel dstChannel = ((FileOutputStream)dst).getChannel();
                     FileChannel srcChannel = ((FileInputStream)src).getChannel();){
                    copied = IOUtil.copyStreamChannel(dstChannel, srcChannel);
                    break block13;
                }
            }
            copied = IOUtil.copyStreamStandard(dst, src);
        }
        return copied;
    }

    private static long copyStreamChannel(FileChannel dst, FileChannel src) throws IOException {
        long transferred;
        long position = 0L;
        for (long remaining = src.size(); remaining > 0L; remaining -= transferred) {
            transferred = dst.transferFrom(src, position, Defaults.DEFAULT_BUFFER_SIZE);
            position += transferred;
        }
        dst.position(position);
        return position;
    }

    private static long copyStreamStandard(OutputStream dst, InputStream src) throws IOException {
        int read;
        byte[] buffer = new byte[Defaults.DEFAULT_BUFFER_SIZE];
        long copied = 0L;
        while ((read = src.read(buffer)) >= 0) {
            dst.write(buffer, 0, read);
            copied += (long)read;
        }
        return copied;
    }

    public static long copyStream(File dst, InputStream src) throws IOException {
        long copied;
        try (FileOutputStream dstStream = new FileOutputStream(dst);){
            copied = IOUtil.copyStream(dstStream, src);
        }
        return copied;
    }

    public static long copyFile(OutputStream dst, File src) throws IOException {
        long copied;
        try (FileInputStream srcStream = new FileInputStream(src);){
            copied = IOUtil.copyStream(dst, (InputStream)srcStream);
        }
        return copied;
    }

    public static long copyFile(File dst, File src) throws IOException {
        long copied;
        try (FileInputStream srcStream = new FileInputStream(src);){
            copied = IOUtil.copyStream(dst, (InputStream)srcStream);
        }
        return copied;
    }

    public static long copyUrl(OutputStream dst, URL src) throws IOException {
        long copied;
        try (InputStream srcStream = src.openStream();){
            copied = IOUtil.copyStream(dst, srcStream);
        }
        return copied;
    }

    public static long copyUrl(File dst, URL src) throws IOException {
        long copied;
        try (InputStream srcStream = src.openStream();){
            copied = IOUtil.copyStream(dst, srcStream);
        }
        return copied;
    }

    public static long copyChannel(WritableByteChannel dst, ReadableByteChannel src) throws IOException {
        int read;
        ByteBuffer buffer = ByteBuffer.allocateDirect(Defaults.DEFAULT_BUFFER_SIZE);
        long copied = 0L;
        while ((read = src.read(buffer)) >= 0) {
            buffer.flip();
            dst.write(buffer);
            buffer.clear();
            copied += (long)read;
        }
        return copied;
    }

    public static int copyBuffer(OutputStream dst, ByteBuffer buffer) throws IOException {
        int remaining = buffer.remaining();
        int copied = 0;
        if (remaining > 0) {
            if (buffer.hasArray()) {
                byte[] bufferArray = buffer.array();
                int bufferArrayOffset = buffer.arrayOffset();
                int bufferPosition = buffer.position();
                dst.write(bufferArray, bufferArrayOffset + bufferPosition, remaining);
                buffer.position(bufferPosition + remaining);
            } else {
                byte[] bufferBytes = new byte[remaining];
                buffer.get(bufferBytes);
                dst.write(bufferBytes);
            }
            copied = remaining;
        }
        return copied;
    }

    public static byte[] readAllBytes(InputStream src) throws IOException {
        return IOUtil.readAllBytes(src, Integer.MAX_VALUE);
    }

    public static byte[] readAllBytes(InputStream src, int limit) throws IOException {
        int read;
        byte[] buffer = new byte[Defaults.DEFAULT_BUFFER_SIZE];
        byte[] bytes = new byte[]{};
        while ((read = src.read(buffer)) > 0) {
            int totalRead = bytes.length + read;
            if (bytes.length + read > limit) {
                InterruptedIOException exception = new InterruptedIOException("Limit reached: " + limit);
                exception.bytesTransferred = totalRead;
                throw exception;
            }
            byte[] newBytes = new byte[totalRead];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
            System.arraycopy(buffer, 0, newBytes, bytes.length, read);
            bytes = newBytes;
        }
        return bytes;
    }

    public static byte[] readAllBytes(File src) throws IOException {
        return IOUtil.readAllBytes(src, Integer.MAX_VALUE);
    }

    public static byte[] readAllBytes(File src, int limit) throws IOException {
        byte[] read;
        try (FileInputStream srcStream = new FileInputStream(src);){
            read = IOUtil.readAllBytes(srcStream, limit);
        }
        return read;
    }

    public static byte[] readAllBytes(URL src) throws IOException {
        return IOUtil.readAllBytes(src, Integer.MAX_VALUE);
    }

    public static byte[] readAllBytes(URL src, int limit) throws IOException {
        byte[] read;
        try (InputStream srcStream = src.openStream();){
            read = IOUtil.readAllBytes(srcStream, limit);
        }
        return read;
    }

    public static int readBlocking(InputStream in, byte[] b) throws IOException {
        return IOUtil.readBlocking(in, b, 0, b.length);
    }

    public static int readBlocking(InputStream in, byte[] b, int off, int len) throws IOException {
        int read;
        int read0;
        for (read = 0; read < len && (read0 = in.read(b, off + read, len - read)) >= 0; read += read0) {
        }
        return read;
    }

    public static int readEager(InputStream in, byte[] b) throws IOException {
        return IOUtil.readEager(in, b, 0, b.length);
    }

    public static int readEager(InputStream in, byte[] b, int off, int len) throws IOException {
        int read;
        int read0;
        for (read = 0; read < len; read += read0) {
            read0 = in.read(b, off + read, len - read);
            if (read0 >= 0) continue;
            throw new EOFException("Unexepcted EOF (expected: " + len + " got: " + read);
        }
        return read;
    }
}

