/*
 * Decompiled with CFR 0.152.
 */
package de.carne.nio.file;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class FileUtil {
    private FileUtil() {
    }

    public static Path tmpDir() {
        return Paths.get(Objects.requireNonNull(System.getProperty("java.io.tmpdir")), new String[0]).toAbsolutePath();
    }

    public static Path userHomeDir() {
        return Paths.get(Objects.requireNonNull(System.getProperty("user.home")), new String[0]).toAbsolutePath();
    }

    public static Path workingDir() {
        return Paths.get(".", new String[0]).toAbsolutePath();
    }

    public static Path touch(Path file) throws IOException {
        if (Files.exists(file, new LinkOption[0])) {
            Files.setLastModifiedTime(file, FileTime.from(Instant.now()));
        } else {
            Files.createFile(file, new FileAttribute[0]);
        }
        return file;
    }

    public static boolean delete(Path fileOrDirectory) throws IOException {
        boolean deleted = false;
        if (Files.exists(fileOrDirectory, LinkOption.NOFOLLOW_LINKS)) {
            deleted = true;
            if (Files.isDirectory(fileOrDirectory, LinkOption.NOFOLLOW_LINKS)) {
                Files.walkFileTree(fileOrDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(@Nullable Path file, @Nullable BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(@Nullable Path dir, @Nullable IOException exc) throws IOException {
                        if (exc != null) {
                            throw exc;
                        }
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            } else {
                Files.delete(fileOrDirectory);
            }
        }
        return deleted;
    }

    public static @NonNull String[] splitPath(String path) {
        String fileName;
        @NonNull String[] split = new String[]{"", "", ""};
        int baseIndex = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        if (baseIndex > 0) {
            split[0] = path.substring(0, baseIndex);
            fileName = path.substring(baseIndex + 1);
        } else if (baseIndex == 0) {
            split[0] = path.substring(0, baseIndex + 1);
            fileName = path.substring(baseIndex + 1);
        } else {
            fileName = path;
        }
        int extIndex = fileName.lastIndexOf(46);
        if (extIndex > 0) {
            split[1] = fileName.substring(0, extIndex);
            split[2] = fileName.substring(extIndex + 1);
        } else {
            split[1] = fileName;
        }
        return split;
    }
}

