/*
 * Decompiled with CFR 0.152.
 */
package de.carne.text;

import de.carne.text.HexChars;

public final class HexBytes {
    private HexBytes() {
    }

    public static String toStringL(byte[] bs) {
        return HexBytes.toStringL(bs, 0, bs.length);
    }

    public static String toStringL(byte[] bs, int off, int len) {
        StringBuilder buffer = new StringBuilder(len);
        for (int byteIndex = 0; byteIndex < len; ++byteIndex) {
            buffer.append(HexChars.LOWER_CASE[bs[off + byteIndex] >> 4 & 0xF]);
            buffer.append(HexChars.LOWER_CASE[bs[off + byteIndex] & 0xF]);
        }
        return buffer.toString();
    }

    public static String toStringU(byte[] bs) {
        return HexBytes.toStringU(bs, 0, bs.length);
    }

    public static String toStringU(byte[] bs, int off, int len) {
        StringBuilder buffer = new StringBuilder(len);
        for (int byteIndex = 0; byteIndex < len; ++byteIndex) {
            buffer.append(HexChars.UPPER_CASE[bs[off + byteIndex] >> 4 & 0xF]);
            buffer.append(HexChars.UPPER_CASE[bs[off + byteIndex] & 0xF]);
        }
        return buffer.toString();
    }

    public static byte[] valueOf(String s) {
        int sLength = s.length();
        if (sLength % 2 != 0) {
            throw new NumberFormatException("Invalid hex sequence: " + s);
        }
        byte[] value = new byte[sLength / 2];
        int cIndex = 0;
        while (cIndex < sLength) {
            int bIndex = cIndex / 2;
            int valueH = HexBytes.valueOf(s.charAt(cIndex++));
            int valueL = HexBytes.valueOf(s.charAt(cIndex++));
            value[bIndex] = (byte)(valueH << 4 | valueL);
        }
        return value;
    }

    public static int valueOf(char c) {
        int value;
        if ('0' <= c && c <= '9') {
            value = c - 48;
        } else if ('a' <= c && c <= 'f') {
            value = 10 + (c - 97);
        } else if ('A' <= c && c <= 'F') {
            value = 10 + (c - 65);
        } else {
            throw new NumberFormatException("Invalid hex char: " + c);
        }
        return value;
    }
}

