/*
 * Decompiled with CFR 0.152.
 */
package de.carne.text;

import de.carne.text.HexChars;
import org.eclipse.jdt.annotation.Nullable;

public final class HexFormat {
    public static final HexFormat UPPER_CASE = new HexFormat(true);
    public static final HexFormat LOWER_CASE = new HexFormat(false);
    private final char[] hexChars;
    private final @Nullable String prefix;
    private final @Nullable String suffix;
    private final int baseBufferSize;

    public HexFormat(boolean upperCase) {
        this(upperCase, null, null);
    }

    public HexFormat(boolean upperCase, @Nullable String prefix, @Nullable String suffix) {
        this.hexChars = upperCase ? HexChars.UPPER_CASE : HexChars.LOWER_CASE;
        this.prefix = prefix;
        this.suffix = suffix;
        this.baseBufferSize = (this.prefix != null ? this.prefix.length() : 0) + (this.suffix != null ? this.suffix.length() : 0);
    }

    public String format(byte b) {
        return this.format(new StringBuilder(this.baseBufferSize + 2), b).toString();
    }

    public StringBuilder format(StringBuilder buffer, byte b) {
        if (this.prefix != null) {
            buffer.append(this.prefix);
        }
        buffer.append(this.hexChars[b >> 4 & 0xF]);
        buffer.append(this.hexChars[b & 0xF]);
        if (this.suffix != null) {
            buffer.append(this.suffix);
        }
        return buffer;
    }

    public String format(byte[] bs) {
        return this.format(new StringBuilder((this.baseBufferSize + 3) * bs.length - 1), bs).toString();
    }

    public StringBuilder format(StringBuilder buffer, byte[] bs) {
        return this.format(buffer, bs, 0, bs.length);
    }

    public String format(byte[] bs, int off, int len) {
        return this.format(new StringBuilder((this.baseBufferSize + 3) * len - 1), bs, off, len).toString();
    }

    public StringBuilder format(StringBuilder buffer, byte[] bs, int off, int len) {
        for (int bIndex = 0; bIndex < len; ++bIndex) {
            if (bIndex > 0) {
                buffer.append(' ');
            }
            this.format(buffer, bs[off + bIndex]);
        }
        return buffer;
    }

    public String format(short s) {
        return this.format(new StringBuilder(this.baseBufferSize + 4), s).toString();
    }

    public StringBuilder format(StringBuilder buffer, short s) {
        if (this.prefix != null) {
            buffer.append(this.prefix);
        }
        buffer.append(this.hexChars[s >> 12 & 0xF]);
        buffer.append(this.hexChars[s >> 8 & 0xF]);
        buffer.append(this.hexChars[s >> 4 & 0xF]);
        buffer.append(this.hexChars[s & 0xF]);
        if (this.suffix != null) {
            buffer.append(this.suffix);
        }
        return buffer;
    }

    public String format(int i) {
        return this.format(new StringBuilder(this.baseBufferSize + 8), i).toString();
    }

    public StringBuilder format(StringBuilder buffer, int i) {
        if (this.prefix != null) {
            buffer.append(this.prefix);
        }
        buffer.append(this.hexChars[i >> 28 & 0xF]);
        buffer.append(this.hexChars[i >> 24 & 0xF]);
        buffer.append(this.hexChars[i >> 20 & 0xF]);
        buffer.append(this.hexChars[i >> 16 & 0xF]);
        buffer.append(this.hexChars[i >> 12 & 0xF]);
        buffer.append(this.hexChars[i >> 8 & 0xF]);
        buffer.append(this.hexChars[i >> 4 & 0xF]);
        buffer.append(this.hexChars[i & 0xF]);
        if (this.suffix != null) {
            buffer.append(this.suffix);
        }
        return buffer;
    }

    public String format(long l) {
        return this.format(new StringBuilder(this.baseBufferSize + 16), l).toString();
    }

    public StringBuilder format(StringBuilder buffer, long l) {
        if (this.prefix != null) {
            buffer.append(this.prefix);
        }
        buffer.append(this.hexChars[(int)(l >> 60 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 56 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 52 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 48 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 44 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 40 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 36 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 32 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 28 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 24 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 20 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 16 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 12 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 8 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l >> 4 & 0xFL)]);
        buffer.append(this.hexChars[(int)(l & 0xFL)]);
        if (this.suffix != null) {
            buffer.append(this.suffix);
        }
        return buffer;
    }
}

