/*
 * Decompiled with CFR 0.152.
 */
package de.carne.text;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class MemoryUnitFormat
extends NumberFormat {
    private static final long serialVersionUID = -9087489563589331679L;
    private static final String[] UNITS = new String[]{" byte", " KiB", " MiB", " GiB", " TiB", " PiB", " EiB", " ZiB", " YiB"};
    private static final ThreadLocal<@NonNull MemoryUnitFormat> CACHED_INSTANCE = ThreadLocal.withInitial(MemoryUnitFormat::new);
    private final NumberFormat numberFormat;

    public MemoryUnitFormat() {
        this(NumberFormat.getNumberInstance());
    }

    public MemoryUnitFormat(Locale inLocale) {
        this(NumberFormat.getNumberInstance(inLocale));
    }

    public MemoryUnitFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public static MemoryUnitFormat getMemoryUnitInstance() {
        return CACHED_INSTANCE.get();
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        int unitIndex = 0;
        double normalizedNumber = Math.abs(number);
        while (normalizedNumber >= 1024.0 && unitIndex + 1 < UNITS.length) {
            normalizedNumber /= 1024.0;
            ++unitIndex;
        }
        return this.numberFormat.format(normalizedNumber *= Math.signum(number), toAppendTo, pos).append(UNITS[unitIndex]);
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        int unitIndex = 0;
        long normalizedNumber = Math.abs(number);
        while (normalizedNumber > 4096L && unitIndex + 1 < UNITS.length) {
            normalizedNumber >>= 10;
            ++unitIndex;
        }
        return this.numberFormat.format(normalizedNumber *= (long)(number >= 0L ? 1 : -1), toAppendTo, pos).append(UNITS[unitIndex]);
    }

    @Override
    public @Nullable Number parse(String source, ParsePosition parsePosition) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(parsePosition);
        int initialParseIndex = parsePosition.getIndex();
        Number number = this.numberFormat.parse(source, parsePosition);
        if (parsePosition.getErrorIndex() < 0) {
            if (number instanceof Long) {
                number = this.parseLong((Long)number, source, parsePosition, initialParseIndex);
            } else if (number instanceof Double) {
                number = this.parseDouble((Double)number, source, parsePosition, initialParseIndex);
            } else {
                parsePosition.setErrorIndex(parsePosition.getIndex());
                parsePosition.setIndex(initialParseIndex);
                number = null;
            }
        }
        return number;
    }

    private @Nullable Long parseLong(Long longNumber, String source, ParsePosition parsePosition, int initialParseIndex) {
        Long parseResult;
        long longValue = longNumber;
        int parseIndex = parsePosition.getIndex();
        for (String unit : UNITS) {
            if (source.startsWith(unit, parseIndex)) {
                parsePosition.setIndex(parseIndex + unit.length());
                break;
            }
            longValue <<= 10;
        }
        if (parseIndex < parsePosition.getIndex()) {
            parseResult = longValue;
        } else {
            parsePosition.setErrorIndex(parseIndex);
            parsePosition.setIndex(initialParseIndex);
            parseResult = null;
        }
        return parseResult;
    }

    private @Nullable Double parseDouble(Double doubleNumber, String source, ParsePosition parsePosition, int initialParseIndex) {
        Double parseResult;
        double doubleValue = doubleNumber;
        int parseIndex = parsePosition.getIndex();
        for (String unit : UNITS) {
            if (source.startsWith(unit, parseIndex)) {
                parsePosition.setIndex(parseIndex + unit.length());
                break;
            }
            doubleValue *= 1024.0;
        }
        if (parseIndex < parsePosition.getIndex()) {
            parseResult = doubleValue;
        } else {
            parsePosition.setErrorIndex(parseIndex);
            parsePosition.setIndex(initialParseIndex);
            parseResult = null;
        }
        return parseResult;
    }

    @Override
    public int hashCode() {
        return this.numberFormat.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return obj instanceof MemoryUnitFormat && this.numberFormat.equals(((MemoryUnitFormat)obj).numberFormat);
    }
}

