/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util;

import de.carne.text.HexFormat;
import de.carne.util.Check;
import de.carne.util.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.jdt.annotation.Nullable;

public final class ByteString
implements Serializable,
Comparable<ByteString> {
    private static final long serialVersionUID = 2167856394985799551L;
    public static final ByteString EMPTY = new ByteString(new byte[0]);
    private final byte[] bytes;
    private final int start;
    private final int length;

    private ByteString(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    private ByteString(byte[] bytes, int start, int length) {
        this.bytes = bytes;
        this.start = start;
        this.length = length;
    }

    public static ByteString wrap(byte ... bytes) {
        return bytes.length > 0 ? new ByteString(bytes) : EMPTY;
    }

    public static ByteString wrap(byte[] bytes, int start, int length) {
        Check.isTrue(0 <= start);
        Check.isTrue(0 <= length);
        Check.isTrue(start + length <= bytes.length);
        return length > 0 ? new ByteString(bytes, start, length) : EMPTY;
    }

    public static ByteString copy(byte ... bytes) {
        return ByteString.copy(bytes, 0, bytes.length);
    }

    public static ByteString copy(byte[] bytes, int start, int length) {
        Check.isTrue(0 <= start);
        Check.isTrue(0 <= length);
        Check.isTrue(start + length <= bytes.length);
        return length > 0 ? new ByteString(Arrays.copyOfRange(bytes, start, start + length)) : EMPTY;
    }

    public int length() {
        return this.length;
    }

    public byte[] bytes() {
        return Arrays.copyOfRange(this.bytes, this.start, this.start + this.length);
    }

    public byte byteAt(int index) {
        Check.isTrue(0 <= index);
        Check.isTrue(index < this.length);
        return this.bytes[this.start + index];
    }

    public void copyTo(byte[] dest, int destPos) {
        Check.isTrue(0 <= destPos);
        Check.isTrue(dest.length - destPos >= this.length);
        System.arraycopy(this.bytes, this.start, dest, destPos, this.length);
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.bytes, this.start, this.length);
    }

    public ByteString slice(int sliceStart, int sliceLength) {
        Check.isTrue(0 <= sliceStart);
        Check.isTrue(0 <= sliceLength);
        Check.isTrue(sliceStart + sliceLength <= this.length);
        return this.start == sliceStart && this.length == sliceLength ? this : new ByteString(this.bytes, this.start + sliceStart, sliceLength);
    }

    @Override
    public int compareTo(ByteString o) {
        int byteIndex2;
        int byteIndex1 = this.start;
        int byteIndexLimit1 = this.start + this.length;
        int byteIndexLImit2 = o.start + o.length;
        int comparison = 0;
        for (byteIndex2 = o.start; byteIndex1 < byteIndexLimit1 && byteIndex2 < byteIndexLImit2 && comparison == 0; ++byteIndex1, ++byteIndex2) {
            comparison = Integer.compare(Byte.toUnsignedInt(this.bytes[byteIndex1]), Byte.toUnsignedInt(o.bytes[byteIndex2]));
        }
        if (comparison == 0) {
            if (byteIndex1 < byteIndexLimit1) {
                comparison = 1;
            } else if (byteIndex2 < byteIndexLImit2) {
                comparison = -1;
            }
        }
        return comparison;
    }

    public int hashCode() {
        int hashLimit = Math.min(4, this.length);
        int hash = 0;
        for (int hashIndex = 0; hashIndex < hashLimit; ++hashIndex) {
            hash = hash << 8 | this.bytes[this.start + hashIndex] & 0xFF;
        }
        return hash;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof ByteString && this.compareTo((ByteString)obj) == 0;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int formatLimit = Math.min(16, this.length);
        HexFormat.LOWER_CASE.format(buffer, this.bytes, this.start, formatLimit);
        if (formatLimit < this.length) {
            buffer.append(Strings.ELLIPSIS);
        }
        return buffer.toString();
    }
}

