/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util;

import de.carne.util.logging.Log;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jdt.annotation.Nullable;

public final class Exceptions {
    private static final Log LOG = new Log();

    private Exceptions() {
    }

    public static RuntimeException toRuntime(Throwable exception) {
        return exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception.getLocalizedMessage(), exception);
    }

    public static void ignore(@Nullable Throwable exception) {
        if (exception != null) {
            LOG.trace(exception, "Ignored exception: {0}", exception.getClass().getTypeName());
        }
    }

    public static void warn(@Nullable Throwable exception) {
        if (exception != null) {
            LOG.warning(exception, "Ignored exception: {0}", exception.getClass().getTypeName());
        }
    }

    public static String getMessage(@Nullable Throwable exception) {
        String message = "<none>";
        if (exception != null && (message = exception.getLocalizedMessage()) == null && (message = exception.getMessage()) == null) {
            message = exception.getClass().getName();
        }
        return message;
    }

    public static Throwable getCause(Throwable exception) {
        Throwable cause = exception.getCause();
        return cause != null ? cause : exception;
    }

    public static String getStackTrace(Throwable exception) {
        String stackTrace = null;
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            exception.printStackTrace(pw);
            pw.flush();
            stackTrace = sw.toString();
        }
        catch (IOException e) {
            Exceptions.warn(e);
        }
        return stackTrace != null ? stackTrace : "<no stack trace>";
    }

    public static String toString(Throwable e) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(e.getClass().getName());
        String message = e.getLocalizedMessage();
        if (message == null || message.isEmpty()) {
            message = e.getMessage();
        }
        if (message != null && !message.isEmpty()) {
            buffer.append(": ").append(message);
        }
        return buffer.toString();
    }
}

