/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util;

import de.carne.util.Exceptions;
import de.carne.util.Threads;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ManifestInfos {
    public static final String ATTRIBUTE_MODULE_ID = "X-Module-Id";
    public static final String ATTRIBUTE_MODULE_NAME = "X-Module-Name";
    public static final String ATTRIBUTE_MODULE_VERSION = "X-Module-Version";
    public static final String ATTRIBUTE_BUILD_TIMESTAMP = "Build-Timestamp";
    public static final String NA = "n/a";
    private final String moduleId;
    private final Manifest manifest;

    private ManifestInfos(String moduleId, Manifest manifest) {
        this.moduleId = moduleId;
        this.manifest = manifest;
    }

    public ManifestInfos(String moduleId) {
        this(moduleId, ManifestInfos.findManifest(moduleId));
    }

    public static SortedMap<String, ManifestInfos> getRuntimeInfos() {
        TreeMap<String, ManifestInfos> runtimeInfos = new TreeMap<String, ManifestInfos>();
        try {
            Enumeration<URL> manifestUrls = ManifestInfos.getManifestResources();
            while (manifestUrls.hasMoreElements()) {
                String moduleId;
                Manifest manifest = ManifestInfos.loadManifestResource(manifestUrls.nextElement());
                Attributes attributes = manifest.getMainAttributes();
                if (attributes == null || (moduleId = attributes.getValue(ATTRIBUTE_MODULE_ID)) == null) continue;
                runtimeInfos.put(moduleId, new ManifestInfos(moduleId, manifest));
            }
        }
        catch (IOException e) {
            Exceptions.ignore(e);
        }
        return runtimeInfos;
    }

    public String getMainAttribute(String attributeName, String defaultValue) {
        Attributes attributes = this.manifest.getMainAttributes();
        String attributeValue = attributes != null ? attributes.getValue(attributeName) : null;
        return attributeValue != null ? attributeValue : defaultValue;
    }

    public String id() {
        return this.moduleId;
    }

    public String name() {
        return this.getMainAttribute(ATTRIBUTE_MODULE_NAME, NA);
    }

    public String version() {
        return this.getMainAttribute(ATTRIBUTE_MODULE_VERSION, NA);
    }

    public String build() {
        return this.getMainAttribute(ATTRIBUTE_BUILD_TIMESTAMP, NA);
    }

    private static Manifest findManifest(String moduleId) {
        Manifest found = null;
        try {
            Enumeration<URL> manifestUrls = ManifestInfos.getManifestResources();
            while (manifestUrls.hasMoreElements()) {
                Manifest manifest = ManifestInfos.loadManifestResource(manifestUrls.nextElement());
                Attributes attributes = manifest.getMainAttributes();
                if (attributes == null || !moduleId.equals(attributes.getValue(ATTRIBUTE_MODULE_ID))) continue;
                found = manifest;
                break;
            }
        }
        catch (IOException e) {
            Exceptions.ignore(e);
        }
        return found != null ? found : new Manifest();
    }

    private static Enumeration<URL> getManifestResources() throws IOException {
        return Threads.getContextClassLoader().getResources("META-INF/MANIFEST.MF");
    }

    private static Manifest loadManifestResource(URL manifestUrl) throws IOException {
        Manifest manifest;
        try (InputStream manifestStream = manifestUrl.openStream();){
            manifest = new Manifest(manifestStream);
        }
        return manifest;
    }

    public String toString() {
        return this.name() + " " + this.version() + " (build: " + this.build() + ")";
    }
}

