/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util;

import de.carne.util.logging.Log;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public final class PropertyResolver {
    private static final Log LOG = new Log();
    private final Map<String, String> properties;
    private final boolean useSystemProperties;
    private final boolean useEnvironment;

    public PropertyResolver() {
        this(Collections.emptyMap(), true, true);
    }

    public PropertyResolver(Map<?, ?> properties) {
        this(properties, true, true);
    }

    public PropertyResolver(boolean useSystemProperties, boolean useEnvironemnt) {
        this(Collections.emptyMap(), useSystemProperties, useEnvironemnt);
    }

    public PropertyResolver(Map<?, ?> properties, boolean useSystemProperties, boolean useEnvironemnt) {
        this.properties = new HashMap<String, String>(properties.size());
        for (Map.Entry<?, ?> property : properties.entrySet()) {
            this.properties.put(String.valueOf(property.getKey()), String.valueOf(property.getValue()));
        }
        this.useSystemProperties = useSystemProperties;
        this.useEnvironment = useEnvironemnt;
    }

    public @Nullable String resolve(String key) {
        String value = this.properties.get(key);
        if (value == null && this.useSystemProperties) {
            value = System.getProperty(key);
        }
        if (value == null && this.useEnvironment) {
            value = System.getenv(key.replace('.', '_').toUpperCase());
        }
        LOG.debug("Resolved ''{0}'' to ''{1}''", key, value);
        return value;
    }

    public String resolve(String key, String defaultValue) {
        String value = this.resolve(key);
        return value != null ? value : defaultValue;
    }

    public String expand(String s) throws ParseException {
        Expansions expansions = new Expansions(s);
        StringBuilder expanded = null;
        if (expansions.hasRemaining()) {
            expanded = new StringBuilder();
            do {
                expansions.processAndAdvance(expanded, this);
            } while (expansions.hasRemaining());
            expansions.flush(expanded);
        }
        return expanded != null ? expanded.toString() : s;
    }

    private static class Expansions {
        private static final char TAG = '$';
        private static final char LBRACE = '{';
        private static final char RBRACE = '}';
        private final String s;
        private int fromIndex = 0;
        private int toIndex;

        Expansions(String s) {
            this.s = s;
            this.toIndex = s.indexOf(36);
        }

        public boolean hasRemaining() {
            return 0 <= this.toIndex && this.toIndex < this.s.length();
        }

        public void flush(StringBuilder expanded) {
            int flushIndex;
            int n = flushIndex = this.toIndex >= 0 ? this.toIndex : this.s.length();
            if (this.fromIndex < flushIndex) {
                expanded.append(this.s, this.fromIndex, flushIndex);
                this.fromIndex = flushIndex;
            }
        }

        public void processAndAdvance(StringBuilder expanded, PropertyResolver resolver) throws ParseException {
            this.flush(expanded);
            char peek = this.peek();
            if (peek == '{') {
                this.processKey(expanded, resolver);
            } else if (peek == '$') {
                this.processQuote(expanded);
            } else {
                throw new ParseException("Unexpected char: " + peek, this.toIndex);
            }
            this.toIndex = this.s.indexOf(36, this.fromIndex);
        }

        private void processKey(StringBuilder expanded, PropertyResolver resolver) throws ParseException {
            int keyIndex = this.toIndex + 2;
            int rBraceIndex = this.s.indexOf(125, keyIndex);
            if (rBraceIndex < 0) {
                throw new ParseException("Missing }", this.toIndex);
            }
            String key = this.s.substring(keyIndex, rBraceIndex);
            String value = resolver.resolve(key);
            if (value == null) {
                throw new ParseException("Unknown key: " + key, keyIndex);
            }
            expanded.append(value);
            this.fromIndex = rBraceIndex + 1;
        }

        private void processQuote(StringBuilder expanded) {
            expanded.append('$');
            this.fromIndex = this.toIndex + 2;
        }

        private char peek() {
            int peekIndex = this.toIndex + 1;
            return 0 < peekIndex && peekIndex < this.s.length() ? this.s.charAt(peekIndex) : (char)'\u0000';
        }
    }
}

