/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util;

import de.carne.util.SystemProperties;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class Strings {
    public static final String ELLIPSIS = SystemProperties.value(Strings.class, ".ellipsis", "\u2026");
    private static char[] hexCharsUpper = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private Strings() {
    }

    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.length() == 0;
    }

    public static boolean notEmpty(@Nullable String s) {
        return s != null && s.length() > 0;
    }

    public static String valueOf(@Nullable Object o) {
        return String.valueOf(String.valueOf(o));
    }

    public static String safe(@Nullable String s) {
        return s != null ? s : "";
    }

    public static String safeTrim(@Nullable String s) {
        return s != null ? s.trim() : "";
    }

    public static @Nullable String trim(@Nullable String s) {
        return s != null ? s.trim() : s;
    }

    public static @NonNull String[] split(String s, char delim, boolean all) {
        ArrayList<String> splits = new ArrayList<String>();
        int splitIndex = -1;
        while (true) {
            int nextSplitIndex;
            int n = nextSplitIndex = splitIndex == -1 || all ? s.indexOf(delim, splitIndex + 1) : -1;
            if (nextSplitIndex < 0) break;
            splits.add(s.substring(splitIndex + 1, nextSplitIndex));
            splitIndex = nextSplitIndex;
        }
        splits.add(s.substring(splitIndex + 1));
        return splits.toArray(new String[splits.size()]);
    }

    public static String join(Object[] objects, String delim) {
        return Strings.join(Arrays.asList(objects), delim, Integer.MAX_VALUE, ELLIPSIS);
    }

    public static String join(Iterable<?> objects, String delim) {
        return Strings.join(objects, delim, Integer.MAX_VALUE, ELLIPSIS);
    }

    public static String join(Object[] objects, String delim, int limit) {
        return Strings.join(Arrays.asList(objects), delim, limit, ELLIPSIS);
    }

    public static String join(Iterable<?> objects, String delim, int limit) {
        return Strings.join(objects, delim, limit, ELLIPSIS);
    }

    public static String join(Object[] objects, String delim, int limit, String ellipsis) {
        return Strings.join(Arrays.asList(objects), delim, limit, ellipsis);
    }

    public static String join(Iterable<?> objects, String delim, int limit, String ellipsis) {
        StringBuilder joined = new StringBuilder();
        boolean limitReached = false;
        for (Object object : objects) {
            if (joined.length() > 0) {
                limitReached = Strings.joinLimit(joined, delim, limit);
            }
            if (!(limitReached = limitReached || Strings.joinLimit(joined, Strings.valueOf(object), limit))) continue;
            break;
        }
        if (limitReached) {
            int joinedLength = joined.length();
            int replaceLength = Math.min(ellipsis.length(), joinedLength);
            int replaceStart = joinedLength - replaceLength;
            for (int replaceIndex = 0; replaceIndex < replaceLength; ++replaceIndex) {
                joined.setCharAt(replaceStart + replaceIndex, ellipsis.charAt(replaceIndex));
            }
        }
        return joined.toString();
    }

    private static boolean joinLimit(StringBuilder joined, String s, int limit) {
        int maxAppend = limit - joined.length();
        boolean limitReached = s.length() > maxAppend;
        joined.append(!limitReached ? s : s.substring(0, maxAppend));
        return limitReached;
    }

    public static String encode(CharSequence chars) {
        return Strings.encode(new StringBuilder(), chars).toString();
    }

    public static StringBuilder encode(StringBuilder buffer, CharSequence chars) {
        chars.chars().forEach(c -> {
            if (c == 92) {
                buffer.append("\\\\");
            } else if (c == 34) {
                buffer.append("\\\"");
            } else if (32 <= c && c <= 126) {
                buffer.append((char)c);
            } else {
                switch (c) {
                    case 0: {
                        buffer.append("\\0");
                        break;
                    }
                    case 8: {
                        buffer.append("\\b");
                        break;
                    }
                    case 9: {
                        buffer.append("\\t");
                        break;
                    }
                    case 10: {
                        buffer.append("\\n");
                        break;
                    }
                    case 12: {
                        buffer.append("\\f");
                        break;
                    }
                    case 13: {
                        buffer.append("\\r");
                        break;
                    }
                    default: {
                        buffer.append("\\u").append(hexCharsUpper[c >> 12 & 0xF]).append(hexCharsUpper[c >> 8 & 0xF]).append(hexCharsUpper[c >> 4 & 0xF]).append(hexCharsUpper[c & 0xF]);
                    }
                }
            }
        });
        return buffer;
    }

    public static String decode(CharSequence chars) {
        CharDecoder decoder = new CharDecoder();
        chars.chars().forEach(decoder::decode);
        return decoder.getDecoded();
    }

    public static String encodeHtml(CharSequence chars) {
        return Strings.encodeHtml(new StringBuilder(), chars).toString();
    }

    public static StringBuilder encodeHtml(StringBuilder buffer, CharSequence chars) {
        chars.chars().forEach(c -> {
            switch (c) {
                case 60: {
                    buffer.append("&lt;");
                    break;
                }
                case 62: {
                    buffer.append("&gt;");
                    break;
                }
                case 38: {
                    buffer.append("&amp;");
                    break;
                }
                case 34: {
                    buffer.append("&quot;");
                    break;
                }
                case 39: {
                    buffer.append("&apos;");
                    break;
                }
                default: {
                    if (32 <= c && c <= 126) {
                        buffer.append((char)c);
                        break;
                    }
                    buffer.append("&#").append(c).append(';');
                }
            }
        });
        return buffer;
    }

    private static class CharDecoder {
        private final StringBuilder buffer = new StringBuilder();
        private boolean quoted = false;
        private int encodeIndex = 0;
        private int decodedC = 0;

        CharDecoder() {
        }

        public void decode(int c) {
            if (!this.quoted) {
                this.decodeUnquoted(c);
            } else if (this.encodeIndex == 0) {
                this.decodeQuoted(c);
            } else {
                this.decodeQuotedEncoded(c);
            }
        }

        private void decodeUnquoted(int c) {
            if (c != 92) {
                this.buffer.append((char)c);
            } else {
                this.quoted = true;
            }
        }

        private void decodeQuoted(int c) {
            block11: {
                block10: {
                    if (c == 117) break block10;
                    this.quoted = false;
                    switch (c) {
                        case 92: {
                            this.buffer.append('\\');
                            break block11;
                        }
                        case 48: {
                            this.buffer.append('\u0000');
                            break block11;
                        }
                        case 98: {
                            this.buffer.append('\b');
                            break block11;
                        }
                        case 116: {
                            this.buffer.append('\t');
                            break block11;
                        }
                        case 110: {
                            this.buffer.append('\n');
                            break block11;
                        }
                        case 102: {
                            this.buffer.append('\f');
                            break block11;
                        }
                        case 114: {
                            this.buffer.append('\r');
                            break block11;
                        }
                        case 34: {
                            this.buffer.append('\"');
                            break block11;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected quoted character: " + (char)c);
                        }
                    }
                }
                this.encodeIndex = 1;
                this.decodedC = 0;
            }
        }

        private void decodeQuotedEncoded(int c) {
            this.encodeIndex = (this.encodeIndex + 1) % 5;
            this.quoted = this.encodeIndex != 0;
            this.decodedC <<= 4;
            if (48 <= c && c <= 57) {
                this.decodedC |= c - 48;
            } else if (97 <= c && c <= 102) {
                this.decodedC |= c - 97 + 10;
            } else if (65 <= c && c <= 70) {
                this.decodedC |= c - 65 + 10;
            } else {
                throw new IllegalArgumentException("Unexpected encoded character: " + (char)c);
            }
            if (!this.quoted) {
                this.buffer.append((char)this.decodedC);
            }
        }

        public String getDecoded() {
            return this.buffer.toString();
        }
    }
}

