/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util;

import de.carne.util.Exceptions;

public final class Threads {
    private Threads() {
    }

    public static void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public static boolean sleep(long millis) {
        boolean interrupted = false;
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Exceptions.ignore(e);
            Thread.currentThread().interrupt();
            interrupted = true;
        }
        return !interrupted;
    }

    public static ClassLoader getContextClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl != null ? cl : ClassLoader.getSystemClassLoader();
    }
}

