/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.logging;

import de.carne.util.Lazy;
import de.carne.util.logging.LogLevel;
import de.carne.util.logging.Logs;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.Nullable;

public final class Log {
    private final Logger logger;
    private static final Lazy<Log> rootHolder;

    public Log() {
        this(Logger.getLogger(Log.getCallerClassName()));
    }

    public Log(String resourceBundleName) {
        this(Logger.getLogger(Log.getCallerClassName(), resourceBundleName));
    }

    public Log(Class<?> clazz) {
        this(Logger.getLogger(clazz.getName()));
    }

    public Log(Class<?> clazz, String resourceBundleName) {
        this(Logger.getLogger(clazz.getName(), resourceBundleName));
    }

    private Log(Logger logger) {
        this.logger = logger;
    }

    public static Log root() {
        return rootHolder.get();
    }

    public Logger logger() {
        return this.logger;
    }

    public Level level() {
        Logger currentLogger = this.logger;
        Level level = currentLogger.getLevel();
        while (level == null) {
            currentLogger = currentLogger != null ? currentLogger.getParent() : null;
            level = currentLogger != null ? currentLogger.getLevel() : LogLevel.LEVEL_INFO;
        }
        return level;
    }

    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    public void log(Level level, @Nullable Throwable thrown, String msg, Object ... parameters) {
        if (this.logger.isLoggable(level)) {
            this.logger.log(level, thrown, () -> MessageFormat.format(msg, parameters));
        }
    }

    public boolean isNoticeLoggable() {
        return this.isLoggable(LogLevel.LEVEL_NOTICE);
    }

    public void notice(String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_NOTICE, null, msg, parameters);
    }

    public void notice(Throwable thrown, String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_NOTICE, thrown, msg, parameters);
    }

    public boolean isErrorLoggable() {
        return this.isLoggable(LogLevel.LEVEL_ERROR);
    }

    public void error(String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_ERROR, null, msg, parameters);
    }

    public void error(Throwable thrown, String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_ERROR, thrown, msg, parameters);
    }

    public boolean isWarningLoggable() {
        return this.isLoggable(LogLevel.LEVEL_WARNING);
    }

    public void warning(String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_WARNING, null, msg, parameters);
    }

    public void warning(Throwable thrown, String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_WARNING, thrown, msg, parameters);
    }

    public boolean isInfoLoggable() {
        return this.isLoggable(LogLevel.LEVEL_INFO);
    }

    public void info(String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_INFO, null, msg, parameters);
    }

    public void info(Throwable thrown, String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_INFO, thrown, msg, parameters);
    }

    public boolean isDebugLoggable() {
        return this.isLoggable(LogLevel.LEVEL_DEBUG);
    }

    public void debug(String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_DEBUG, null, msg, parameters);
    }

    public void debug(Throwable thrown, String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_DEBUG, thrown, msg, parameters);
    }

    public boolean isTraceLoggable() {
        return this.isLoggable(LogLevel.LEVEL_TRACE);
    }

    public void trace(String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_TRACE, null, msg, parameters);
    }

    public void trace(Throwable thrown, String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_TRACE, thrown, msg, parameters);
    }

    public void callee() {
        this.callee(LogLevel.LEVEL_DEBUG);
    }

    public void callee(Level level) {
        this.log(level, null, Log.getCalleeSignature(), new Object[0]);
    }

    private static String getCallerClassName() {
        StackTraceElement caller = Log.getCaller();
        return caller != null ? caller.getClassName() : Log.class.getName();
    }

    private static String getCalleeSignature() {
        StackTraceElement caller = Log.getCaller();
        return caller != null ? caller.toString() : "<unkown>";
    }

    private static @Nullable StackTraceElement getCaller() {
        int steIndex;
        String thisClassName = Log.class.getName();
        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
        for (steIndex = 0; steIndex < stes.length && !thisClassName.equals(stes[steIndex].getClassName()); ++steIndex) {
        }
        while (steIndex < stes.length && thisClassName.equals(stes[steIndex].getClassName())) {
            ++steIndex;
        }
        return steIndex < stes.length ? stes[steIndex] : null;
    }

    public String toString() {
        return Objects.toString(this.logger.getName());
    }

    static {
        Logs.initialize();
        rootHolder = new Lazy<Log>(() -> new Log(Logger.getLogger("")));
    }
}

