/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.logging;

import de.carne.util.Strings;
import de.carne.util.logging.LogLevel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class Logs {
    public static final String CONFIG_BOOT = "logging-boot.properties";
    public static final ErrorManager DEFAULT_ERROR_MANAGER = new ErrorManager();
    public static final String CONFIG_DEFAULT = "logging-default.properties";
    public static final String CONFIG_VERBOSE = "logging-verbose.properties";
    public static final String CONFIG_DEBUG = "logging-debug.properties";

    private Logs() {
    }

    static void initialize() {
    }

    public static void flush() {
        LogManager manager = LogManager.getLogManager();
        Enumeration<String> loggerNames = manager.getLoggerNames();
        HashSet<Handler> handlers = new HashSet<Handler>();
        while (loggerNames.hasMoreElements()) {
            String loggerName = loggerNames.nextElement();
            Logger logger = manager.getLogger(loggerName);
            if (logger == null) continue;
            for (Handler handler : logger.getHandlers()) {
                if (!handlers.add(handler)) continue;
                handler.flush();
            }
        }
    }

    public static void readConfig(String config) throws IOException {
        LogManager manager = LogManager.getLogManager();
        try (InputStream configInputStream = Logs.openConfig(config);){
            manager.readConfiguration(configInputStream);
        }
        Logs.applyApplicationConfig(manager);
    }

    public static void readConfig(URL config) throws IOException {
        LogManager manager = LogManager.getLogManager();
        try (InputStream configInputStream = config.openStream();){
            manager.readConfiguration(configInputStream);
        }
        Logs.applyApplicationConfig(manager);
    }

    private static InputStream openConfig(String config) throws FileNotFoundException {
        InputStream configInputStream = Logs.getContextClassLoader().getResourceAsStream(config);
        if (configInputStream == null) {
            throw new FileNotFoundException("Unable to open logging config: " + config);
        }
        return configInputStream;
    }

    private static void applyApplicationConfig(LogManager manager) {
        @NonNull String[] handlerNames = Logs.getStringsProperty(manager, "application.handlers");
        if (handlerNames.length > 0) {
            Logger rootLogger = manager.getLogger("");
            if (rootLogger != null) {
                Level rootLoggerLevel = rootLogger.getLevel();
                if (rootLoggerLevel == null) {
                    rootLoggerLevel = Level.INFO;
                }
                LogLevel rootLoggerLogLevel = LogLevel.fromLevel(rootLoggerLevel);
                for (String handlerName : handlerNames) {
                    try {
                        Handler handler = Logs.newClassInstance(handlerName, Handler.class);
                        Level level = Logs.getLevelProperty(manager, handlerName + ".level", rootLoggerLogLevel);
                        handler.setLevel(level);
                        rootLogger.addHandler(handler);
                    }
                    catch (ReflectiveOperationException e) {
                        DEFAULT_ERROR_MANAGER.error("Unable to instantiate handler: " + handlerName, e, 0);
                    }
                }
            } else {
                DEFAULT_ERROR_MANAGER.error("Root logger not yet available; failed to apply application handlers", null, 0);
            }
        }
    }

    public static void applyLevelConfig(String levelConfig) {
        StringTokenizer configEntries = new StringTokenizer(levelConfig, ";");
        while (configEntries.hasMoreElements()) {
            String configEntry = configEntries.nextToken();
            try {
                String[] split = Strings.split(configEntry, '=', false);
                if (split.length != 2) {
                    throw new IllegalArgumentException();
                }
                String loggerName = split[0].trim();
                String levelName = split[1].trim();
                if (Strings.isEmpty(loggerName) || Strings.isEmpty(levelName)) {
                    throw new IllegalArgumentException();
                }
                Level level = Level.parse(levelName);
                Logger.getLogger(loggerName).setLevel(level);
            }
            catch (IllegalArgumentException e) {
                DEFAULT_ERROR_MANAGER.error("Unrecognized level config: " + configEntry, e, 0);
            }
        }
    }

    public static String getStringProperty(LogManager manager, String name, String defaultValue) {
        String property = manager.getProperty(name);
        return property != null ? property : defaultValue;
    }

    public static @NonNull String[] getStringsProperty(LogManager manager, String name) {
        String property = manager.getProperty(name);
        ArrayList<@NonNull String> propertyValue = new ArrayList<String>();
        if (property != null) {
            StringTokenizer propertyTokens = new StringTokenizer(property, " ,");
            while (propertyTokens.hasMoreElements()) {
                String propertyToken = propertyTokens.nextToken().trim();
                if (propertyToken.length() <= 0) continue;
                propertyValue.add(propertyToken);
            }
        }
        return propertyValue.toArray(new String[propertyValue.size()]);
    }

    public static int getIntProperty(LogManager manager, String name, int defaultValue) {
        String property = manager.getProperty(name);
        int propertyValue = defaultValue;
        if (property != null) {
            try {
                propertyValue = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                DEFAULT_ERROR_MANAGER.error("Invalid int property " + name, e, 0);
            }
        }
        return propertyValue;
    }

    public static boolean getBooleanProperty(LogManager manager, String name, boolean defaultValue) {
        String property = manager.getProperty(name);
        boolean propertyValue = defaultValue;
        if (property != null) {
            propertyValue = Boolean.parseBoolean(property.trim());
        }
        return propertyValue;
    }

    public static Level getLevelProperty(LogManager manager, String name, LogLevel defaultValue) {
        String property = manager.getProperty(name);
        Level propertyValue = defaultValue;
        if (property != null) {
            try {
                propertyValue = Level.parse(property.trim());
            }
            catch (Exception e) {
                DEFAULT_ERROR_MANAGER.error("Invalid level property: " + name, e, 0);
            }
        }
        return propertyValue;
    }

    public static @Nullable Filter getFilterProperty(LogManager manager, String name, @Nullable Filter defaultValue) {
        String property = manager.getProperty(name);
        Filter propertyValue = defaultValue;
        if (property != null) {
            try {
                propertyValue = Logs.newClassInstance(property, Filter.class);
            }
            catch (ReflectiveOperationException e) {
                DEFAULT_ERROR_MANAGER.error("Invalid filter property: " + name, e, 0);
            }
        }
        return propertyValue;
    }

    public static Formatter getFormatterProperty(LogManager manager, String name, Formatter defaultValue) {
        String property = manager.getProperty(name);
        Formatter propertyValue = defaultValue;
        if (property != null) {
            try {
                propertyValue = Logs.newClassInstance(property, Formatter.class);
            }
            catch (ReflectiveOperationException e) {
                DEFAULT_ERROR_MANAGER.error("Invalid formatter property: " + name, e, 0);
            }
        }
        return propertyValue;
    }

    private static <T> T newClassInstance(String name, Class<T> type) throws ReflectiveOperationException {
        return Class.forName(name, false, Logs.getContextClassLoader()).asSubclass(type).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl != null ? cl : ClassLoader.getSystemClassLoader();
    }

    static {
        LogLevel.LEVEL_NOTICE.getName();
        if (System.getProperty("java.util.logging.config.class") == null && System.getProperty("java.util.logging.config.file") == null && Logs.class.getClassLoader().equals(ClassLoader.getSystemClassLoader())) {
            try {
                Logs.readConfig(CONFIG_BOOT);
            }
            catch (IOException e) {
                DEFAULT_ERROR_MANAGER.error("Failed to read logging config: logging-boot.properties", e, 0);
            }
        }
    }
}

