/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.logging;

import de.carne.util.Lazy;

final class PublishLock
implements AutoCloseable {
    private static final Lazy<PublishLock> INSTANCE_HOLDER = new Lazy<PublishLock>(PublishLock::new);
    private final ThreadLocal<Boolean> locked = ThreadLocal.withInitial(() -> Boolean.FALSE);

    private PublishLock() {
    }

    public static PublishLock getInstance() {
        return INSTANCE_HOLDER.get();
    }

    public void ifNotLocked(Runnable publisher) {
        if (!this.locked.get().booleanValue()) {
            try {
                this.locked.set(Boolean.TRUE);
                publisher.run();
            }
            finally {
                this.locked.set(Boolean.FALSE);
            }
        }
    }

    @Override
    public void close() {
        this.locked.remove();
    }
}

