/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.prefs;

import de.carne.boot.ShutdownHooks;
import de.carne.util.logging.Log;
import de.carne.util.prefs.DataStore;
import de.carne.util.prefs.FilePreferences;
import de.carne.util.prefs.FileStore;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

abstract class FilePreferencesStore {
    private static final Log LOG = new Log();
    private static final Set<FileStore> FILE_STORES = new HashSet<FileStore>();
    private @Nullable Properties cachedData = null;
    private List<Consumer<Properties>> changeLog = new LinkedList<Consumer<Properties>>();

    FilePreferencesStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FilePreferencesStore fromFile(Path file) {
        FileStore fileStore = new FileStore(file);
        Set<FileStore> set = FILE_STORES;
        synchronized (set) {
            if (FILE_STORES.isEmpty()) {
                ShutdownHooks.add(FilePreferencesStore::flushFileStores);
            }
            FILE_STORES.add(fileStore);
        }
        return fileStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushFileStores() {
        LOG.info("Flushing all opended file stores...", new Object[0]);
        Set<FileStore> set = FILE_STORES;
        synchronized (set) {
            for (FileStore fileStore : FILE_STORES) {
                try {
                    fileStore.flush();
                }
                catch (BackingStoreException e) {
                    LOG.error(e, "Failed to store configuration file: ''{0}''", fileStore);
                }
            }
        }
    }

    public static FilePreferencesStore fromData(Properties data) {
        return new DataStore(data);
    }

    public FilePreferences root() {
        return new FilePreferences(this);
    }

    public synchronized void put(FilePreferences preferences, String key, String value) {
        String preferencesKey = this.getPreferencesKey(preferences, key);
        this.recordChange(data -> data.put(preferencesKey, value));
    }

    public synchronized @Nullable String get(FilePreferences preferences, String key) {
        String preferencesKey = this.getPreferencesKey(preferences, key);
        return this.getCachedData().getProperty(preferencesKey);
    }

    public synchronized void remove(FilePreferences preferences, String key) {
        String preferencesKey = this.getPreferencesKey(preferences, key);
        this.recordChange(data -> data.remove(preferencesKey));
    }

    public synchronized void removeNode(FilePreferences preferences) {
        String preferencesKeyPrefix = this.getPreferencesKey(preferences, "");
        this.recordChange(data -> {
            Iterator<Map.Entry<Object, Object>> entryIterator = data.entrySet().iterator();
            while (entryIterator.hasNext()) {
                if (!entryIterator.next().getKey().toString().startsWith(preferencesKeyPrefix)) continue;
                entryIterator.remove();
            }
        });
    }

    public synchronized String[] keys(FilePreferences preferences) {
        String preferencesKeyPrefix = this.getPreferencesKey(preferences, "");
        Set<@NonNull String> keys = this.getCachedData().keySet().stream().map(Object::toString).map(key -> this.extractKey(preferencesKeyPrefix, (String)key)).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        return keys.toArray(new String[keys.size()]);
    }

    public synchronized String[] childrenNames(FilePreferences preferences) {
        String preferencesKeyPrefix = this.getPreferencesKey(preferences, "");
        Set<String> childrenNames = this.getCachedData().keySet().stream().map(Object::toString).map(key -> this.extractChildrenName(preferencesKeyPrefix, (String)key)).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        return childrenNames.toArray(new String[childrenNames.size()]);
    }

    public synchronized FilePreferences child(FilePreferences preferences, String name) {
        return new FilePreferences(preferences, name);
    }

    public synchronized void sync() throws BackingStoreException {
        LOG.info("Syncing preferences store ''{0}''...", this);
        try {
            this.cachedData = this.syncData(this.changeLog);
        }
        catch (IOException e) {
            throw new BackingStoreException(e);
        }
        this.changeLog.clear();
    }

    public synchronized void flush() throws BackingStoreException {
        if (!this.changeLog.isEmpty()) {
            LOG.debug("FLushing preferences store ''{0}''...", this);
            try {
                this.syncData(this.changeLog);
            }
            catch (IOException e) {
                throw new BackingStoreException(e);
            }
            this.changeLog.clear();
        }
    }

    private void recordChange(Consumer<Properties> change) {
        Properties data = this.getCachedData();
        change.accept(data);
        this.changeLog.add(change);
    }

    private String getPreferencesKey(Preferences preferences, String key) {
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(preferences.absolutePath());
        if (preferences.parent() != null) {
            keyBuilder.append('/');
        }
        keyBuilder.append(key);
        return keyBuilder.toString();
    }

    private String extractKey(String prefix, String preferencesKey) {
        int keyIndex;
        String key = "";
        if (preferencesKey.startsWith(prefix) && preferencesKey.indexOf(47, keyIndex = prefix.length()) < 0) {
            key = preferencesKey.substring(keyIndex);
        }
        return key;
    }

    private String extractChildrenName(String prefix, String preferencesKey) {
        int childrenNameIndex;
        int nextIndex;
        String childrenName = "";
        if (preferencesKey.startsWith(prefix) && (nextIndex = preferencesKey.indexOf(47, childrenNameIndex = prefix.length())) > childrenNameIndex) {
            childrenName = preferencesKey.substring(childrenNameIndex, nextIndex);
        }
        return childrenName;
    }

    private Properties getCachedData() {
        Properties data = this.cachedData;
        if (data == null) {
            try {
                data = this.loadData();
            }
            catch (IOException e) {
                LOG.error(e, "Failed to load configuration file: ''{0}''", this);
                data = new Properties();
            }
            this.cachedData = data;
        }
        return data;
    }

    protected abstract Properties loadData() throws IOException;

    protected abstract Properties syncData(List<Consumer<Properties>> var1) throws IOException;
}

