/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.prefs;

import de.carne.util.logging.Log;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class UserFile {
    private static final Log LOG = new Log();
    private static final String FILE_ATTRIBUTE_VIEW_POSIX = "posix";
    private static final String FILE_ATTRIBUTE_VIEW_ACL = "acl";

    private UserFile() {
    }

    public static FileChannel open(Path file, OpenOption ... extraOptions) throws IOException {
        Files.createDirectories(file.getParent(), UserFile.userDirectoryAttributes(file));
        HashSet<OpenOption> openOptions = new HashSet<OpenOption>(Arrays.asList(extraOptions));
        openOptions.add(StandardOpenOption.CREATE);
        return FileChannel.open(file, openOptions, UserFile.userFileAttributes(file));
    }

    private static FileAttribute<?>[] userDirectoryAttributes(Path path) throws IOException {
        FileSystem fileSystem = path.getFileSystem();
        Set<String> fileAttributeViews = fileSystem.supportedFileAttributeViews();
        ArrayList<FileAttribute<Collection<Object>>> attributes = new ArrayList<FileAttribute<Collection<Object>>>();
        if (fileAttributeViews.contains(FILE_ATTRIBUTE_VIEW_POSIX)) {
            EnumSet<PosixFilePermission> posixPermissions = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE);
            attributes.add(PosixFilePermissions.asFileAttribute(posixPermissions));
        } else if (fileAttributeViews.contains(FILE_ATTRIBUTE_VIEW_ACL)) {
            AclEntry acl = AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(UserFile.getCurrentUser(fileSystem)).setPermissions(AclEntryPermission.values()).build();
            attributes.add(UserFile.asFileAttribute(acl));
        } else {
            LOG.warning("No supported access control model found {0} for user directory ''{1}''", fileAttributeViews, path);
        }
        return attributes.toArray(new FileAttribute[attributes.size()]);
    }

    private static FileAttribute<?>[] userFileAttributes(Path path) throws IOException {
        FileSystem fileSystem = path.getFileSystem();
        Set<String> fileAttributeViews = fileSystem.supportedFileAttributeViews();
        ArrayList<FileAttribute<Collection<Object>>> attributes = new ArrayList<FileAttribute<Collection<Object>>>();
        if (fileAttributeViews.contains(FILE_ATTRIBUTE_VIEW_POSIX)) {
            EnumSet<PosixFilePermission> posixPermissions = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
            attributes.add(PosixFilePermissions.asFileAttribute(posixPermissions));
        } else if (fileAttributeViews.contains(FILE_ATTRIBUTE_VIEW_ACL)) {
            AclEntry acl = AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(UserFile.getCurrentUser(fileSystem)).setPermissions(AclEntryPermission.values()).build();
            attributes.add(UserFile.asFileAttribute(acl));
        } else {
            LOG.warning("No supported access control model found {0} for user file ''{1}''", fileAttributeViews, path);
        }
        return attributes.toArray(new FileAttribute[attributes.size()]);
    }

    private static UserPrincipal getCurrentUser(FileSystem fileSystem) throws IOException {
        return Objects.requireNonNull(fileSystem.getUserPrincipalLookupService().lookupPrincipalByName(Objects.requireNonNull(System.getProperty("user.name"))));
    }

    private static FileAttribute<List<AclEntry>> asFileAttribute(final AclEntry ... value) {
        return new FileAttribute<List<AclEntry>>(){

            @Override
            public String name() {
                return "acl:acl";
            }

            @Override
            public List<AclEntry> value() {
                return Arrays.asList(value);
            }
        };
    }
}

