/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.validation;

import de.carne.util.validation.Conversion;
import de.carne.util.validation.Validation;
import de.carne.util.validation.ValidationException;
import de.carne.util.validation.ValidationMessage;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.Nullable;

public class InputValidator<I>
implements Supplier<I> {
    private final I input;

    protected InputValidator(I input) {
        this.input = input;
    }

    public static <I> InputValidator<I> input(I input) {
        return new InputValidator<I>(input);
    }

    public static <I> InputValidator<I> checkNotNull(@Nullable I input, ValidationMessage message) throws ValidationException {
        if (input == null) {
            throw new ValidationException(message.format(input));
        }
        return new InputValidator<I>(input);
    }

    public InputValidator<I> check(Validation<I> validation, ValidationMessage message) throws ValidationException {
        try {
            if (!validation.check(this.input)) {
                throw new ValidationException(message.format(this.input));
            }
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ValidationException(message.format(this.input), e);
        }
        return this;
    }

    public <O> O convert(Conversion<I, O> conversion, ValidationMessage message) throws ValidationException {
        @Nullable O convertedInput = null;
        try {
            convertedInput = conversion.checkAndApply(this.input);
            if (convertedInput == null) {
                throw new ValidationException(message.format(this.input));
            }
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ValidationException(message.format(this.input), e);
        }
        return convertedInput;
    }

    @Override
    public I get() {
        return this.input;
    }
}

