/*
 * Decompiled with CFR 0.152.
 */
package de.chkal.mvctoolbox.jsp;

import de.chkal.mvctoolbox.jsp.HtmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ClassList {
    private final List<String> list = new ArrayList<String>();

    public static ClassList empty() {
        return new ClassList();
    }

    public static ClassList of(String ... classes) {
        ClassList classList = new ClassList();
        for (String c : classes) {
            classList.add(c);
        }
        return classList;
    }

    private ClassList() {
    }

    public ClassList add(String classes) {
        if (classes != null && classes.trim().length() > 0) {
            this.list.add(classes.trim());
        }
        return this;
    }

    public String getAllClasses() {
        if (!this.list.isEmpty()) {
            return this.list.stream().collect(Collectors.joining(" "));
        }
        return null;
    }

    public void write(HtmlWriter writer) throws IOException {
        String allClasses = this.getAllClasses();
        if (allClasses != null) {
            writer.attribute("class", allClasses);
        }
    }
}

