/*
 * Decompiled with CFR 0.152.
 */
package de.chkal.mvctoolbox.jsp;

import de.chkal.mvctoolbox.jsp.BaseTag;
import de.chkal.mvctoolbox.jsp.HtmlWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.DynamicAttributes;

public abstract class DynamicBaseTag
extends BaseTag
implements DynamicAttributes {
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    protected void writeDynamicAttributes(HtmlWriter writer) throws IOException {
        this.writeDynamicAttributes(writer, Collections.emptyList());
    }

    protected void writeDynamicAttributes(HtmlWriter writer, String ... ignore) throws IOException {
        this.writeDynamicAttributes(writer, Arrays.asList(ignore));
    }

    protected void writeDynamicAttributes(HtmlWriter writer, List<String> ignore) throws IOException {
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            if (ignore.contains(entry.getKey())) continue;
            writer.attribute(entry.getKey(), entry.getValue());
        }
    }

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspException {
        this.attributes.put(localName, value);
    }

    protected Object getDynamicAttribute(String name) {
        return this.attributes.get(name);
    }

    protected String getClassAttribute() {
        Object value = this.getDynamicAttribute("class");
        if (value != null) {
            return value.toString();
        }
        return null;
    }
}

