/*
 * Decompiled with CFR 0.152.
 */
package de.chkal.mvctoolbox.jsp.tag;

import de.chkal.mvctoolbox.core.message.MvcMessage;
import de.chkal.mvctoolbox.core.message.MvcMessages;
import de.chkal.mvctoolbox.jsp.ClassList;
import de.chkal.mvctoolbox.jsp.DynamicBaseTag;
import de.chkal.mvctoolbox.jsp.HtmlWriter;
import java.io.IOException;
import java.util.List;
import javax.servlet.jsp.JspException;

public class MessagesTag
extends DynamicBaseTag {
    private boolean grouping;
    private String infoClass;
    private String warningClass;
    private String errorClass;

    public void doTag() throws JspException, IOException {
        HtmlWriter writer = new HtmlWriter(this.getJspContext());
        MvcMessages messages = this.getBean(MvcMessages.class);
        if (this.grouping) {
            this.renderList(writer, messages.getInfos(), this.infoClass, false);
            this.renderList(writer, messages.getWarnings(), this.warningClass, false);
            this.renderList(writer, messages.getErrors(), this.errorClass, false);
        } else {
            this.renderList(writer, messages.getAll(), null, true);
        }
    }

    private void renderList(HtmlWriter writer, List<MvcMessage> messages, String listClass, boolean styleListEntries) throws IOException {
        if (!messages.isEmpty()) {
            writer.beginStartTag("ul");
            ClassList.of(this.getClassAttribute(), listClass).write(writer);
            writer.endStartTag();
            for (MvcMessage message : messages) {
                this.renderListEntry(writer, message, styleListEntries);
            }
            writer.endTag("ul");
        }
    }

    private void renderListEntry(HtmlWriter writer, MvcMessage message, boolean addSeverityClass) throws IOException {
        writer.beginStartTag("li");
        if (addSeverityClass) {
            ClassList.of(this.getSeverityClass(message.getSeverity())).write(writer);
        }
        writer.endStartTag();
        writer.write(message.getText());
        writer.endTag("li");
    }

    private String getSeverityClass(MvcMessage.Severity severity) {
        switch (severity) {
            case INFO: {
                return this.infoClass;
            }
            case WARNING: {
                return this.warningClass;
            }
            case ERROR: {
                return this.errorClass;
            }
        }
        return null;
    }

    public void setGrouping(boolean grouping) {
        this.grouping = grouping;
    }

    public void setInfoClass(String infoClass) {
        this.infoClass = infoClass;
    }

    public void setWarningClass(String warningClass) {
        this.warningClass = warningClass;
    }

    public void setErrorClass(String errorClass) {
        this.errorClass = errorClass;
    }
}

