/*
 * Decompiled with CFR 0.152.
 */
package de.chkal.mvctoolbox.jsp.tag;

import de.chkal.mvctoolbox.core.model.SelectOption;
import de.chkal.mvctoolbox.jsp.BaseTag;
import de.chkal.mvctoolbox.jsp.HtmlWriter;
import de.chkal.mvctoolbox.jsp.tag.SelectTag;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.JspTag;

public class OptionsTag
extends BaseTag {
    private List items;

    public void doTag() throws JspException, IOException {
        HtmlWriter writer = new HtmlWriter(this.getJspContext());
        Objects.requireNonNull(this.items, "items must not be null");
        for (Object obj : this.items) {
            if (!(obj instanceof SelectOption)) continue;
            this.renderOption(writer, (SelectOption)obj);
        }
    }

    private void renderOption(HtmlWriter writer, SelectOption option) throws IOException {
        writer.beginStartTag("option");
        writer.attribute("value", option.getValue());
        if (this.isSelected(option)) {
            writer.attribute("selected");
        }
        if (option.isDisabled()) {
            writer.attribute("disabled");
        }
        writer.endStartTag();
        writer.write(option.getLabel());
        writer.endTag("option");
    }

    private boolean isSelected(SelectOption option) {
        SelectTag selectTag = (SelectTag)OptionsTag.findAncestorWithClass((JspTag)this, SelectTag.class);
        return selectTag != null && selectTag.isSelected(option.getValue());
    }

    public void setItems(List items) {
        this.items = items;
    }
}

