/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.Configuration;
import de.danielbechler.diff.DefaultNodeFactory;
import de.danielbechler.diff.Differ;
import de.danielbechler.diff.Instances;
import de.danielbechler.diff.TestOnly;
import de.danielbechler.diff.node.DefaultNode;
import de.danielbechler.diff.node.Node;
import de.danielbechler.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PrimitiveDiffer
implements Differ<DefaultNode> {
    private final Configuration configuration;
    private DefaultNodeFactory defaultNodeFactory = new DefaultNodeFactory();

    public PrimitiveDiffer(Configuration configuration) {
        Assert.notNull(configuration, "configuration");
        this.configuration = configuration;
    }

    @Override
    public final DefaultNode compare(Node parentNode, Instances instances) {
        if (!instances.getType().isPrimitive()) {
            throw new IllegalArgumentException("The primitive differ can only deal with primitive types.");
        }
        DefaultNode node = this.defaultNodeFactory.createNode(parentNode, instances);
        if (this.configuration.isIgnored(node)) {
            node.setState(Node.State.IGNORED);
        } else if (this.shouldTreatPrimitiveDefaultsAsUnassigned() && instances.hasBeenAdded()) {
            node.setState(Node.State.ADDED);
        } else if (this.shouldTreatPrimitiveDefaultsAsUnassigned() && instances.hasBeenRemoved()) {
            node.setState(Node.State.REMOVED);
        } else if (!instances.areEqual()) {
            node.setState(Node.State.CHANGED);
        }
        return node;
    }

    private boolean shouldTreatPrimitiveDefaultsAsUnassigned() {
        return this.configuration.getPrimitiveDefaultValueMode() == Configuration.PrimitiveDefaultValueMode.UNASSIGNED;
    }

    @TestOnly
    public void setDefaultNodeFactory(DefaultNodeFactory defaultNodeFactory) {
        this.defaultNodeFactory = defaultNodeFactory;
    }
}

