/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.inclusion;

import de.danielbechler.diff.inclusion.Inclusion;
import de.danielbechler.diff.inclusion.InclusionResolver;
import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.util.Assert;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypePropertyConfigInclusionResolver
implements InclusionResolver {
    private final Map<PropertyId, Inclusion> inclusions = new HashMap<PropertyId, Inclusion>();

    TypePropertyConfigInclusionResolver() {
    }

    @Override
    public Inclusion getInclusion(DiffNode node) {
        if (TypePropertyConfigInclusionResolver.isQualified(node)) {
            PropertyId propertyKey = new PropertyId(node.getParentNode().getValueType(), node.getPropertyName());
            Inclusion inclusion = this.inclusions.get(propertyKey);
            if (inclusion != null && inclusion != Inclusion.DEFAULT) {
                return inclusion;
            }
            if (this.hasIncludedSiblings(node)) {
                return Inclusion.EXCLUDED;
            }
        }
        return Inclusion.DEFAULT;
    }

    @Override
    public boolean enablesStrictIncludeMode() {
        return false;
    }

    private static boolean isQualified(DiffNode node) {
        if (node.isPropertyAware()) {
            if (node.getParentNode() == null || node.getParentNode().getValueType() == null) {
                return false;
            }
            return node.getPropertyName() != null;
        }
        return false;
    }

    private boolean hasIncludedSiblings(DiffNode node) {
        for (Map.Entry<PropertyId, Inclusion> entry : this.inclusions.entrySet()) {
            if (entry.getKey().type != node.getParentNode().getValueType() || entry.getValue() != Inclusion.INCLUDED) continue;
            return true;
        }
        return false;
    }

    public void setInclusion(Class<?> type, String property, Inclusion inclusion) {
        this.inclusions.put(new PropertyId(type, property), inclusion);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyId {
        private final Class<?> type;
        private final String property;

        private PropertyId(Class<?> type, String property) {
            Assert.notNull(type, "type");
            Assert.notNull(property, "property");
            this.type = type;
            this.property = property;
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.property.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyId that = (PropertyId)o;
            if (!this.property.equals(that.property)) {
                return false;
            }
            return this.type.equals(that.type);
        }
    }
}

