/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.util;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Strings {
    private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("\\s*\\n\\s*");

    private Strings() {
    }

    public static boolean hasText(String s) {
        return s != null && s.trim().length() != 0;
    }

    public static boolean isEmpty(String s) {
        return !Strings.hasText(s);
    }

    public static String join(String delimiter, Object ... elements) {
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object part = objectArray[n2];
            if (part != null) {
                if (sb.length() > 0) {
                    sb.append(delimiter);
                }
                sb.append(part.toString());
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String join(String delimiter, Collection<?> elements) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        return Strings.join(delimiter, elements.toArray(new Object[elements.size()]));
    }

    public static String toSingleLineString(Object object) {
        if (object != null) {
            String s = object.toString().trim();
            Matcher matcher = LINE_BREAK_PATTERN.matcher(s);
            return matcher.replaceAll(" \\\\ ");
        }
        return null;
    }

    public static String indent(int times, String text) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < times) {
            sb.append("  ");
            ++i;
        }
        sb.append(text);
        return sb.toString();
    }
}

