/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.core.backend.impl.file.repository.resource;

import de.digitalcollections.core.backend.api.resource.ResourceRepository;
import de.digitalcollections.core.backend.impl.file.repository.resource.util.ResourcePersistenceTypeHandler;
import de.digitalcollections.core.model.api.MimeType;
import de.digitalcollections.core.model.api.resource.Resource;
import de.digitalcollections.core.model.api.resource.enums.ResourcePersistenceType;
import de.digitalcollections.core.model.api.resource.exceptions.ResourceIOException;
import de.digitalcollections.core.model.impl.resource.ResourceImpl;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ReaderInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

@Repository
public class ResourceRepositoryImpl
implements ResourceRepository<Resource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceRepositoryImpl.class);
    @Autowired
    private List<ResourcePersistenceTypeHandler> resourcePersistenceTypeHandlers;
    @Autowired
    ResourceLoader resourceLoader;

    public Resource create(String key, ResourcePersistenceType resourcePersistenceType, MimeType mimeType) throws ResourceIOException {
        Resource resource = this.getResource(key, resourcePersistenceType, mimeType);
        List<URI> uris = this.getUris(key, resourcePersistenceType, mimeType);
        resource.setUri(uris.get(0));
        return resource;
    }

    private Resource getResource(String key, ResourcePersistenceType persistenceType, MimeType mimeType) {
        ResourceImpl resource = new ResourceImpl();
        if (mimeType != null) {
            if (!mimeType.getExtensions().isEmpty()) {
                resource.setFilenameExtension((String)mimeType.getExtensions().get(0));
            }
            resource.setMimeType(mimeType);
        }
        if (ResourcePersistenceType.REFERENCED.equals((Object)persistenceType)) {
            resource.setReadonly(true);
        }
        if (ResourcePersistenceType.MANAGED.equals((Object)persistenceType)) {
            resource.setUuid(UUID.fromString(key));
        }
        return resource;
    }

    public void delete(Resource resource) throws ResourceIOException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public Resource find(String key, ResourcePersistenceType resourcePersistenceType, MimeType mimeType) throws ResourceIOException {
        Resource resource = this.getResource(key, resourcePersistenceType, mimeType);
        List<URI> candidates = this.getUris(key, resourcePersistenceType, mimeType);
        if (candidates.isEmpty()) {
            throw new ResourceIOException("Could not resolve key " + key + "with MIME type " + mimeType.getTypeName() + "to an URI");
        }
        URI uri = candidates.stream().filter(u -> this.resourceLoader.getResource(u.toString()).isReadable()).findFirst().orElseThrow(() -> new ResourceIOException("Could not resolve key " + key + " with MIME type " + mimeType.getTypeName() + " to a readable Resource. Attempted URIs were " + candidates));
        resource.setUri(uri);
        org.springframework.core.io.Resource springResource = this.resourceLoader.getResource(uri.toString());
        long lastModified = this.getLastModified(springResource);
        resource.setLastModified(lastModified);
        long length = this.getSize(springResource);
        resource.setSize(length);
        return resource;
    }

    public byte[] getBytes(Resource resource) throws ResourceIOException {
        try {
            return IOUtils.toByteArray((InputStream)this.getInputStream(resource));
        }
        catch (IOException ex) {
            String msg = "Could not read bytes from resource: " + resource;
            LOGGER.error(msg, (Throwable)ex);
            throw new ResourceIOException(msg, (Throwable)ex);
        }
    }

    public InputStream getInputStream(URI resourceUri) throws ResourceIOException {
        try {
            String location = resourceUri.toString();
            LOGGER.info("Getting inputstream for location '{}'.", (Object)location);
            return this.resourceLoader.getResource(location).getInputStream();
        }
        catch (IOException e) {
            throw new ResourceIOException((Throwable)e);
        }
    }

    public InputStream getInputStream(Resource resource) throws ResourceIOException {
        return this.getInputStream(resource.getUri());
    }

    private long getLastModified(org.springframework.core.io.Resource springResource) {
        try {
            return springResource.lastModified();
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Resource " + springResource.toString() + " does not exist.");
        }
        catch (IOException ex) {
            LOGGER.warn("Can not get lastModified for resource " + springResource.toString(), (Throwable)ex);
        }
        return -1L;
    }

    public Reader getReader(Resource resource) throws ResourceIOException {
        return new InputStreamReader(this.getInputStream(resource));
    }

    public void setResourcePersistenceHandlers(List<ResourcePersistenceTypeHandler> resourcePersistenceTypeHandlers) {
        this.resourcePersistenceTypeHandlers = resourcePersistenceTypeHandlers;
    }

    public ResourcePersistenceTypeHandler getResourcePersistenceTypeHandler(ResourcePersistenceType resourcePersistence) throws ResourceIOException {
        for (ResourcePersistenceTypeHandler resourcePersistenceTypeHandler : this.getResourcePersistenceTypeHandlers()) {
            if (!resourcePersistence.equals((Object)resourcePersistenceTypeHandler.getResourcePersistenceType())) continue;
            return resourcePersistenceTypeHandler;
        }
        throw new ResourceIOException("No ResourcePersistenceHandler defined for " + resourcePersistence);
    }

    public List<ResourcePersistenceTypeHandler> getResourcePersistenceTypeHandlers() {
        if (this.resourcePersistenceTypeHandlers == null) {
            this.resourcePersistenceTypeHandlers = new LinkedList<ResourcePersistenceTypeHandler>();
        }
        return this.resourcePersistenceTypeHandlers;
    }

    private long getSize(org.springframework.core.io.Resource springResource) {
        try {
            long length = springResource.contentLength();
            return length;
        }
        catch (IOException ex) {
            LOGGER.warn("Can not get size for resource " + springResource.toString(), (Throwable)ex);
            return -1L;
        }
    }

    private List<URI> getUris(String key, ResourcePersistenceType persistenceType, MimeType mimeType) throws ResourceIOException {
        ResourcePersistenceTypeHandler handler = this.getResourcePersistenceTypeHandler(persistenceType);
        return handler.getUris(key, mimeType);
    }

    public void write(Resource resource, InputStream payload) throws ResourceIOException {
        Assert.notNull((Object)payload);
        Assert.notNull((Object)resource);
        if (resource.isReadonly()) {
            throw new ResourceIOException("Resource does not support write-operations.");
        }
        URI uri = resource.getUri();
        try {
            if ("http".equals(uri.getScheme()) || "https".equals(uri.getScheme())) {
                throw new ResourceIOException("Scheme not supported for write-operations: " + uri.getScheme() + " (" + uri + ")");
            }
            Files.createDirectories(Paths.get(uri).getParent(), new FileAttribute[0]);
            LOGGER.info("Writing: " + uri);
            IOUtils.copy((InputStream)payload, (OutputStream)new FileOutputStream(Paths.get(uri).toFile()));
        }
        catch (IOException e) {
            String msg = "Could not write data to uri " + String.valueOf(uri);
            LOGGER.error(msg, (Throwable)e);
            throw new ResourceIOException(msg, (Throwable)e);
        }
    }

    public void write(Resource resource, String input) throws ResourceIOException {
        try (ReaderInputStream in = new ReaderInputStream((Reader)new StringReader(input), Charset.forName("UTF-8"));){
            this.write(resource, (InputStream)in);
        }
        catch (IOException ex) {
            String msg = "Could not write data to uri " + String.valueOf(resource.getUri());
            LOGGER.error(msg, (Throwable)ex);
            throw new ResourceIOException(msg, (Throwable)ex);
        }
    }
}

