/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.core.backend.impl.file.repository.resource.resolver;

import de.digitalcollections.core.model.api.MimeType;
import de.digitalcollections.core.model.api.resource.exceptions.ResourceIOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;

public interface FileNameResolver {
    public Boolean isResolvable(String var1);

    public List<String> getStrings(String var1) throws ResourceIOException;

    default public List<String> getStrings(String identifier, MimeType mimeType) throws ResourceIOException {
        return this.getStrings(identifier).stream().filter(s -> MimeType.fromFilename((String)s).matches((Object)mimeType)).collect(Collectors.toList());
    }

    default public List<URI> getUris(String identifier) throws ResourceIOException {
        return this.getStrings(identifier).stream().map(URI::create).collect(Collectors.toList());
    }

    default public List<URI> getUris(String identifier, MimeType mimeType) throws ResourceIOException {
        return this.getUris(identifier).stream().filter(u -> MimeType.fromURI((URI)u).matches((Object)mimeType)).collect(Collectors.toList());
    }

    default public List<Path> getPaths(String identifier) throws ResourceIOException {
        return this.getStrings(identifier).stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
    }

    default public List<Path> getPaths(String identifier, MimeType mimeType) throws ResourceIOException {
        return this.getPaths(identifier).stream().filter(p -> MimeType.fromFilename((String)p.toString()).matches((Object)mimeType)).collect(Collectors.toList());
    }
}

