/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.core.backend.impl.file.repository.resource.resolver;

import de.digitalcollections.core.backend.impl.file.repository.resource.resolver.FileNameResolver;
import de.digitalcollections.core.backend.impl.file.repository.resource.resolver.PatternFileNameResolverImpl;
import de.digitalcollections.core.model.api.resource.exceptions.ResourceIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

@Component
public class MultiPatternsFileNameResolverImpl
implements FileNameResolver,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiPatternsFileNameResolverImpl.class);
    @Value(value="${multiPatternResolvingFile:}")
    private String multiPatternResolvingFile;
    @Autowired
    ResourceLoader resourceLoader;
    private List<PatternFileNameResolverImpl> patternFileNameResolvers = new ArrayList<PatternFileNameResolverImpl>();

    public MultiPatternsFileNameResolverImpl(List<PatternFileNameResolverImpl> patternFileNameResolvers) {
        this.patternFileNameResolvers = patternFileNameResolvers;
    }

    public MultiPatternsFileNameResolverImpl() {
    }

    public void addPattern(String regex, String replacement) {
        PatternFileNameResolverImpl resolver = new PatternFileNameResolverImpl(regex, replacement);
        this.patternFileNameResolvers.add(resolver);
    }

    public void afterPropertiesSet() throws Exception {
        String filepath = this.getMultiPatternResolvingFile();
        if (StringUtils.isEmpty((Object)filepath)) {
            return;
        }
        Resource patRes = this.getResource(filepath);
        if (patRes.exists() && patRes.isReadable()) {
            Constructor constructor = new Constructor(PatternFileNameResolverImpl[].class);
            Yaml yaml = new Yaml((BaseConstructor)constructor);
            this.patternFileNameResolvers = Arrays.asList((PatternFileNameResolverImpl[])yaml.load(patRes.getInputStream()));
        }
    }

    private Resource getResource(String uriPath) throws ResourceIOException {
        URI resourceUri = URI.create(uriPath);
        String location = resourceUri.toString();
        LOGGER.info("Getting inputstream for location '{}'.", (Object)location);
        return this.resourceLoader.getResource(location);
    }

    public String getMultiPatternResolvingFile() {
        return this.multiPatternResolvingFile;
    }

    public void setMultiPatternResolvingFile(String multiPatternResolvingFile) throws Exception {
        this.multiPatternResolvingFile = multiPatternResolvingFile;
        this.afterPropertiesSet();
    }

    @Override
    public List<String> getStrings(String identifier) throws ResourceIOException {
        return this.patternFileNameResolvers.stream().filter(r -> r.isResolvable(identifier)).map(r -> r.getStrings(identifier)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public Boolean isResolvable(String identifier) {
        return this.patternFileNameResolvers.stream().filter(r -> r.isResolvable(identifier)).findFirst().isPresent();
    }
}

