/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.core.backend.impl.file.repository.resource.util;

import de.digitalcollections.core.backend.impl.file.repository.resource.util.ResourcePersistenceTypeHandler;
import de.digitalcollections.core.model.api.MimeType;
import de.digitalcollections.core.model.api.resource.enums.ResourcePersistenceType;
import de.digitalcollections.core.model.api.resource.exceptions.ResourceIOException;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ManagedResourcePersistenceTypeHandler
implements ResourcePersistenceTypeHandler {
    @Value(value="${resourceRepository.managedPathFactory.namespace}")
    private String namespace;
    private String repositoryFolderPath;

    @Value(value="${resourceRepository.managedPathFactory.folderpath}")
    public void setRepositoryFolderPath(String path) {
        this.repositoryFolderPath = path.replace("~", System.getProperty("user.home"));
    }

    @Override
    public List<URI> getUris(String key, MimeType mimeType) throws ResourceIOException {
        String uuidPath = this.getSplittedUuidPath(key);
        Path path = Paths.get(this.getRepositoryFolderPath(), this.getNamespace(), uuidPath, key);
        String location = path.toString();
        location = location + "." + (String)mimeType.getExtensions().get(0);
        return Collections.singletonList(URI.create(location));
    }

    private String getNamespace() {
        return this.namespace;
    }

    private String getRepositoryFolderPath() {
        return this.repositoryFolderPath;
    }

    @Override
    public ResourcePersistenceType getResourcePersistenceType() {
        return ResourcePersistenceType.MANAGED;
    }

    protected String getSplittedUuidPath(String uuid) {
        String uuidWithoutDashes = uuid.replaceAll("-", "");
        CharSequence[] pathParts = ManagedResourcePersistenceTypeHandler.splitEqually(uuidWithoutDashes, 4);
        String splittedUuidPath = String.join((CharSequence)File.separator, pathParts);
        return splittedUuidPath;
    }

    protected static String[] splitEqually(String text, int partLength) {
        int textLength = text.length();
        int numberOfParts = (textLength + partLength - 1) / partLength;
        String[] parts = new String[numberOfParts];
        int offset = 0;
        for (int i = 0; i < numberOfParts; ++i) {
            parts[i] = text.substring(offset, Math.min(offset + partLength, textLength));
            offset += partLength;
        }
        return parts;
    }
}

