/*
 * Decompiled with CFR 0.152.
 */
package de.hamstersimulator.objectsfirst.testframework;

import de.hamstersimulator.objectsfirst.external.simple.game.SimpleHamsterGame;
import de.hamstersimulator.objectsfirst.testframework.HamsterGameTestEnvironment;
import de.hamstersimulator.objectsfirst.testframework.HamsterTest;
import de.hamstersimulator.objectsfirst.testframework.gamestate.RecordingHamsterGameTestEnvironment;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class HamsterGameResolver
implements ParameterResolver {
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type = parameterContext.getParameter().getType();
        return type.equals(HamsterGameTestEnvironment.class) || type.equals(RecordingHamsterGameTestEnvironment.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (!this.supportsParameter(parameterContext, extensionContext)) {
            throw new ParameterResolutionException("Unsupported parameter type");
        }
        SimpleHamsterGame game = this.createSimpleHamsterGame(parameterContext, extensionContext);
        Class<?> type = parameterContext.getParameter().getType();
        return this.resolveTestEnvironment(game, type);
    }

    private SimpleHamsterGame createSimpleHamsterGame(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<? extends SimpleHamsterGame> simpleHamsterGameClass = HamsterGameResolver.getHamsterGameClass(parameterContext, extensionContext).orElseThrow(() -> new ParameterResolutionException("The given class is no SimpleHamsterGame or doesn't exist"));
        try {
            return simpleHamsterGameClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ParameterResolutionException("The simple hamster game to instantiate has public constructor without parameters", (Throwable)e);
        }
    }

    private HamsterGameTestEnvironment resolveTestEnvironment(SimpleHamsterGame game, Class<?> type) {
        if (type.equals(HamsterGameTestEnvironment.class)) {
            return new HamsterGameTestEnvironment(game);
        }
        if (type.equals(RecordingHamsterGameTestEnvironment.class)) {
            return new RecordingHamsterGameTestEnvironment(game);
        }
        throw new IllegalStateException("cannot resolve type: " + type.getName());
    }

    private static Optional<Class<? extends SimpleHamsterGame>> getHamsterGameClass(ParameterContext parameterContext, ExtensionContext extensionContext) {
        try {
            Optional<HamsterTest> hamsterTest = HamsterGameResolver.getHamsterTestAnnotation(parameterContext, extensionContext);
            if (hamsterTest.isPresent()) {
                String hamsterClassName = hamsterTest.get().game();
                Class<?> declaredGameClass = Class.forName(hamsterClassName);
                if (!SimpleHamsterGame.class.isAssignableFrom(declaredGameClass)) {
                    return Optional.empty();
                }
                return Optional.of(declaredGameClass);
            }
            return Optional.empty();
        }
        catch (ClassNotFoundException classEx) {
            return Optional.empty();
        }
    }

    private static Optional<HamsterTest> getHamsterTestAnnotation(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Optional<HamsterTest> annotationFromTestClass = extensionContext.getTestClass().map(testClass -> testClass.getAnnotation(HamsterTest.class));
        if (annotationFromTestClass.isPresent()) {
            return annotationFromTestClass;
        }
        return Optional.ofNullable(parameterContext.getDeclaringExecutable().getDeclaringClass().getAnnotation(HamsterTest.class));
    }
}

