/*
 * Decompiled with CFR 0.152.
 */
package de.hamstersimulator.objectsfirst.testframework.gamelog;

import de.hamstersimulator.objectsfirst.adapter.observables.ObservableGrain;
import de.hamstersimulator.objectsfirst.adapter.observables.ObservableHamster;
import de.hamstersimulator.objectsfirst.adapter.observables.ObservableTerritory;
import de.hamstersimulator.objectsfirst.adapter.observables.ObservableTile;
import de.hamstersimulator.objectsfirst.adapter.observables.ObservableTileContent;
import de.hamstersimulator.objectsfirst.adapter.observables.ObservableWall;
import de.hamstersimulator.objectsfirst.adapter.observables.command.specification.ObservableCommandSpecification;
import de.hamstersimulator.objectsfirst.adapter.observables.command.specification.hamster.ObservableInitHamsterCommandSpecification;
import de.hamstersimulator.objectsfirst.adapter.observables.command.specification.hamster.ObservableMoveCommandSpecification;
import de.hamstersimulator.objectsfirst.adapter.observables.command.specification.hamster.ObservablePickGrainCommandSpecification;
import de.hamstersimulator.objectsfirst.adapter.observables.command.specification.hamster.ObservablePutGrainCommandSpecification;
import de.hamstersimulator.objectsfirst.adapter.observables.command.specification.hamster.ObservableTurnLeftCommandSpecification;
import de.hamstersimulator.objectsfirst.adapter.observables.command.specification.hamster.ObservableWriteCommandSpecification;
import de.hamstersimulator.objectsfirst.adapter.observables.command.specification.territory.ObservableInitializeTerritoryCommandSpecification;
import de.hamstersimulator.objectsfirst.datatypes.Location;
import de.hamstersimulator.objectsfirst.testframework.gamelog.datatypes.GameLog;
import de.hamstersimulator.objectsfirst.testframework.gamelog.datatypes.GrainData;
import de.hamstersimulator.objectsfirst.testframework.gamelog.datatypes.HamsterData;
import de.hamstersimulator.objectsfirst.testframework.gamelog.datatypes.InitHamsterLogEntry;
import de.hamstersimulator.objectsfirst.testframework.gamelog.datatypes.LogEntry;
import de.hamstersimulator.objectsfirst.testframework.gamelog.datatypes.MoveLogEntry;
import de.hamstersimulator.objectsfirst.testframework.gamelog.datatypes.PickGrainLogEntry;
import de.hamstersimulator.objectsfirst.testframework.gamelog.datatypes.PutGrainLogEntry;
import de.hamstersimulator.objectsfirst.testframework.gamelog.datatypes.TerritoryData;
import de.hamstersimulator.objectsfirst.testframework.gamelog.datatypes.TileContentData;
import de.hamstersimulator.objectsfirst.testframework.gamelog.datatypes.TurnLeftLogEntry;
import de.hamstersimulator.objectsfirst.testframework.gamelog.datatypes.WallData;
import de.hamstersimulator.objectsfirst.testframework.gamelog.datatypes.WriteLogEntry;
import de.hamstersimulator.objectsfirst.utils.LambdaVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public final class GameLogFactory {
    private final LambdaVisitor<ObservableCommandSpecification, LogEntry> logVisitor;
    private final LambdaVisitor<ObservableTileContent, TileContentData> tileContentVisitor;
    private final TerritoryData territoryData;
    private final List<LogEntry> logEntries = new ArrayList<LogEntry>();
    private final Map<ObservableHamster, Integer> hamsterIdLookup = new HashMap<ObservableHamster, Integer>();
    private final ReentrantLock lock = new ReentrantLock(true);
    private volatile int idCounter = 0;

    public GameLogFactory(ObservableTerritory territory) {
        this.logVisitor = new LambdaVisitor().on(ObservableMoveCommandSpecification.class).then(this::fromMove).on(ObservableTurnLeftCommandSpecification.class).then(this::fromTurnLeft).on(ObservablePutGrainCommandSpecification.class).then(this::fromPutGrain).on(ObservablePickGrainCommandSpecification.class).then(this::fromPickGrain).on(ObservableInitHamsterCommandSpecification.class).then(this::fromInit).on(ObservableWriteCommandSpecification.class).then(this::fromWrite).on(ObservableInitializeTerritoryCommandSpecification.class).then(this::fromInitTerritory);
        this.tileContentVisitor = new LambdaVisitor().on(ObservableHamster.class).then(hamster -> new HamsterData((Location)hamster.getCurrentLocation().orElseThrow(), this.hamsterIdLookup.get(hamster), hamster.getDirection())).on(ObservableGrain.class).then(grain -> new GrainData((Location)grain.getCurrentLocation().orElseThrow())).on(ObservableWall.class).then(wall -> new WallData((Location)wall.getCurrentLocation().orElseThrow()));
        this.territoryData = this.createTerritoryData(territory);
    }

    private TerritoryData createTerritoryData(ObservableTerritory territory) {
        for (ObservableHamster hamster : territory.getHamsters()) {
            this.registerHamster(hamster);
        }
        ArrayList<TileContentData> datas = new ArrayList<TileContentData>();
        for (ObservableTile tile : territory.tilesProperty()) {
            for (ObservableTileContent content : tile.contentProperty()) {
                datas.add((TileContentData)this.tileContentVisitor.apply((Object)content));
            }
        }
        return new TerritoryData(territory.getSize(), datas);
    }

    private LogEntry fromInitTerritory(ObservableInitializeTerritoryCommandSpecification spec) {
        throw new UnsupportedOperationException("Hard resetting a recorded game is not (yet) supported.");
    }

    private LogEntry fromWrite(ObservableWriteCommandSpecification writeCommandSpecification) {
        WriteLogEntry logEntry = new WriteLogEntry(this.hamsterIdLookup.get(writeCommandSpecification.getHamster()), writeCommandSpecification.getMessage());
        this.logEntries.add(logEntry);
        return logEntry;
    }

    private LogEntry fromInit(ObservableInitHamsterCommandSpecification initCommandSpecification) {
        HamsterData hamsterData = new HamsterData(initCommandSpecification.getLocation(), this.registerHamster(initCommandSpecification.getHamster()), initCommandSpecification.getNewDirection());
        InitHamsterLogEntry logEntry = new InitHamsterLogEntry(hamsterData);
        this.logEntries.add(logEntry);
        return logEntry;
    }

    private LogEntry fromMove(ObservableMoveCommandSpecification moveCommandSpecification) {
        MoveLogEntry logEntry = new MoveLogEntry(this.hamsterIdLookup.get(moveCommandSpecification.getHamster()));
        this.logEntries.add(logEntry);
        return logEntry;
    }

    private LogEntry fromTurnLeft(ObservableTurnLeftCommandSpecification turnCommandSpecification) {
        TurnLeftLogEntry logEntry = new TurnLeftLogEntry(this.hamsterIdLookup.get(turnCommandSpecification.getHamster()));
        this.logEntries.add(logEntry);
        return logEntry;
    }

    private LogEntry fromPutGrain(ObservablePutGrainCommandSpecification putCommandSpecification) {
        PutGrainLogEntry logEntry = new PutGrainLogEntry(this.hamsterIdLookup.get(putCommandSpecification.getHamster()));
        this.logEntries.add(logEntry);
        return logEntry;
    }

    private LogEntry fromPickGrain(ObservablePickGrainCommandSpecification pickCommandSpecification) {
        PickGrainLogEntry logEntry = new PickGrainLogEntry(this.hamsterIdLookup.get(pickCommandSpecification.getHamster()));
        this.logEntries.add(logEntry);
        return logEntry;
    }

    public GameLog toGameLog() {
        return new GameLog(this.territoryData, this.logEntries);
    }

    private int registerHamster(ObservableHamster hamster) {
        int newId = this.idCounter++;
        this.hamsterIdLookup.put(hamster, newId);
        return newId;
    }

    public LogEntry applyNextCommand(ObservableCommandSpecification commandSpecification) {
        this.lock.lock();
        try {
            LogEntry logEntry = (LogEntry)this.logVisitor.apply((Object)commandSpecification);
            return logEntry;
        }
        finally {
            this.lock.unlock();
        }
    }
}

