/*
 * Decompiled with CFR 0.152.
 */
package de.hamstersimulator.objectsfirst.testframework.gamestate;

import de.hamstersimulator.objectsfirst.adapter.observables.ObservableHamster;
import de.hamstersimulator.objectsfirst.adapter.observables.command.specification.ObservableCommandSpecification;
import de.hamstersimulator.objectsfirst.datatypes.Location;
import de.hamstersimulator.objectsfirst.datatypes.Size;
import de.hamstersimulator.objectsfirst.testframework.gamestate.HamsterState;
import de.hamstersimulator.objectsfirst.testframework.gamestate.WrittenMessage;
import de.hamstersimulator.objectsfirst.utils.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class GameState {
    private final int[][] territoryGrainCount;
    private final HashMap<ObservableHamster, HamsterState> hamsterStates;
    private Optional<GameState> previousGameState = Optional.empty();
    private Optional<GameState> nextGameState = Optional.empty();
    private Optional<ObservableCommandSpecification> commandSpecification = Optional.empty();
    private final ArrayList<WrittenMessage> writtenMessages;
    private final int timeStamp;

    GameState(Size size) {
        this(size.getRowCount(), size.getColumnCount());
    }

    private GameState(int rowCount, int columnCount) {
        this.territoryGrainCount = new int[rowCount][columnCount];
        this.hamsterStates = new HashMap();
        this.writtenMessages = new ArrayList();
        this.timeStamp = 0;
    }

    GameState(GameState previousState) {
        Preconditions.checkNotNull((Object)previousState);
        Preconditions.checkState((boolean)previousState.isFinalState());
        this.territoryGrainCount = this.clone2dArray(previousState);
        this.hamsterStates = new HashMap<ObservableHamster, HamsterState>(previousState.getHamsterStates());
        this.writtenMessages = new ArrayList<WrittenMessage>(previousState.writtenMessages);
        this.previousGameState = Optional.of(previousState);
        previousState.nextGameState = Optional.of(this);
        this.timeStamp = previousState.timeStamp + 1;
    }

    public int grainCountAt(Location location) {
        Preconditions.checkNotNull((Object)location);
        Preconditions.checkArgument((this.territoryGrainCount.length > location.getRow() ? 1 : 0) != 0);
        Preconditions.checkArgument((this.territoryGrainCount[0].length > location.getColumn() ? 1 : 0) != 0);
        return this.getTerritoryGrainCount()[location.getRow()][location.getColumn()];
    }

    public HamsterState getHamsterState(ObservableHamster hamster) {
        Preconditions.checkState((boolean)this.getHamsterStates().containsKey(hamster), (String)"The given hamster does not exist on the territory.");
        return this.getHamsterStates().get(hamster);
    }

    public boolean isInitialState() {
        return this.previousGameState.isEmpty();
    }

    public boolean isFinalState() {
        return this.nextGameState.isEmpty();
    }

    public GameState getPreviousGameState() {
        Preconditions.checkState((!this.isInitialState() ? 1 : 0) != 0);
        return this.previousGameState.get();
    }

    public GameState getNextGameState() {
        Preconditions.checkState((!this.isFinalState() ? 1 : 0) != 0);
        return this.nextGameState.get();
    }

    public int getTimestamp() {
        return this.timeStamp;
    }

    public Optional<ObservableCommandSpecification> getCommandSpecification() {
        return this.commandSpecification;
    }

    public List<WrittenMessage> getMessageList() {
        return Collections.unmodifiableList(this.writtenMessages);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.timeStamp;
        result = 31 * result + Arrays.deepHashCode((Object[])this.territoryGrainCount);
        result = 31 * result + Objects.hash(this.hamsterStates);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GameState other = (GameState)obj;
        return Objects.equals(this.hamsterStates, other.hamsterStates) && Objects.equals(this.previousGameState, other.previousGameState) && Objects.equals(this.nextGameState, other.nextGameState) && Objects.equals(this.timeStamp, other.timeStamp) && Arrays.deepEquals((Object[])this.territoryGrainCount, (Object[])other.territoryGrainCount);
    }

    int[][] getTerritoryGrainCount() {
        return this.territoryGrainCount;
    }

    HashMap<ObservableHamster, HamsterState> getHamsterStates() {
        return this.hamsterStates;
    }

    List<WrittenMessage> messageList() {
        return this.writtenMessages;
    }

    void setCommandSpecification(ObservableCommandSpecification newCommandSpecification) {
        this.commandSpecification = Optional.of(newCommandSpecification);
    }

    private int[][] clone2dArray(GameState previousState) {
        return (int[][])Arrays.stream(previousState.getTerritoryGrainCount()).map(rec$ -> (int[])((int[])rec$).clone()).toArray(x$0 -> new int[x$0][]);
    }
}

