/*
 * Decompiled with CFR 0.152.
 */
package de.hamstersimulator.objectsfirst.testframework.gamestate;

import de.hamstersimulator.objectsfirst.adapter.observables.ObservableHamster;
import de.hamstersimulator.objectsfirst.adapter.observables.ObservableTerritory;
import de.hamstersimulator.objectsfirst.adapter.observables.ObservableTile;
import de.hamstersimulator.objectsfirst.adapter.observables.command.specification.ObservableCommandSpecification;
import de.hamstersimulator.objectsfirst.adapter.observables.command.specification.hamster.ObservableAbstractHamsterCommandSpecification;
import de.hamstersimulator.objectsfirst.adapter.observables.command.specification.hamster.ObservableInitHamsterCommandSpecification;
import de.hamstersimulator.objectsfirst.adapter.observables.command.specification.hamster.ObservableMoveCommandSpecification;
import de.hamstersimulator.objectsfirst.adapter.observables.command.specification.hamster.ObservablePickGrainCommandSpecification;
import de.hamstersimulator.objectsfirst.adapter.observables.command.specification.hamster.ObservablePutGrainCommandSpecification;
import de.hamstersimulator.objectsfirst.adapter.observables.command.specification.hamster.ObservableTurnLeftCommandSpecification;
import de.hamstersimulator.objectsfirst.adapter.observables.command.specification.hamster.ObservableWriteCommandSpecification;
import de.hamstersimulator.objectsfirst.adapter.observables.command.specification.territory.ObservableInitializeTerritoryCommandSpecification;
import de.hamstersimulator.objectsfirst.datatypes.Location;
import de.hamstersimulator.objectsfirst.testframework.gamestate.GameState;
import de.hamstersimulator.objectsfirst.testframework.gamestate.GrainDelta;
import de.hamstersimulator.objectsfirst.testframework.gamestate.HamsterState;
import de.hamstersimulator.objectsfirst.testframework.gamestate.WrittenMessage;
import de.hamstersimulator.objectsfirst.utils.LambdaVisitor;
import de.hamstersimulator.objectsfirst.utils.Preconditions;
import java.util.HashMap;
import java.util.Optional;

final class GameStateFactory {
    private static final GrainDelta PICK_GRAIN_DELTA = new GrainDelta(1, 0);
    private static final GrainDelta PUT_GRAIN_DELTA = new GrainDelta(0, 1);
    private static final int GRAIN_PICKED = -1;
    private static final int GRAIN_DROPPED = 1;
    private Optional<GameState> constructedState = Optional.empty();
    private final LambdaVisitor<ObservableCommandSpecification, Void> logVisitor = new LambdaVisitor().on(ObservableMoveCommandSpecification.class).then(this::fromMove).on(ObservableTurnLeftCommandSpecification.class).then(this::fromTurnLeft).on(ObservablePutGrainCommandSpecification.class).then(this::fromPutGrain).on(ObservablePickGrainCommandSpecification.class).then(this::fromPickGrain).on(ObservableInitHamsterCommandSpecification.class).then(this::fromInit).on(ObservableWriteCommandSpecification.class).then(this::fromWrite).on(ObservableInitializeTerritoryCommandSpecification.class).then(this::fromInitTerritory);

    public static GameStateFactory newGameStateFactory() {
        return new GameStateFactory();
    }

    public GameStateFactory cloneFromPreviousState(GameState previousState) {
        Preconditions.checkNotNull((Object)previousState);
        Preconditions.checkState((boolean)this.constructedState.isEmpty());
        this.constructedState = Optional.of(new GameState(previousState));
        return this;
    }

    public GameState constructNextState(ObservableCommandSpecification commandSpecification) {
        Preconditions.checkState((!this.constructedState.isEmpty() ? 1 : 0) != 0);
        this.constructedState.get().setCommandSpecification(commandSpecification);
        this.logVisitor.apply((Object)commandSpecification);
        return this.constructedState.get();
    }

    public GameState fromInitialTerritory(ObservableTerritory observableTerritory) {
        Preconditions.checkNotNull((Object)observableTerritory);
        Preconditions.checkState((observableTerritory.getHamsters().size() == 1 ? 1 : 0) != 0);
        Preconditions.checkState((observableTerritory.getSize().getColumnCount() > 0 && observableTerritory.getSize().getRowCount() > 0 ? 1 : 0) != 0);
        GameState result = new GameState(observableTerritory.getSize());
        ObservableHamster defaultHamster = observableTerritory.getDefaultHamster();
        HamsterState defaultHamsterState = new HamsterState(defaultHamster.getDirection(), (Location)defaultHamster.getCurrentLocation().get(), 0, 0);
        result.getHamsterStates().put(defaultHamster, defaultHamsterState);
        for (ObservableTile tile : observableTerritory.tilesProperty()) {
            result.getTerritoryGrainCount()[tile.getLocation().getRow()][tile.getLocation().getColumn()] = tile.getGrainCount();
        }
        return result;
    }

    private GameStateFactory() {
    }

    private Void fromInitTerritory(ObservableInitializeTerritoryCommandSpecification spec) {
        throw new UnsupportedOperationException("Hard resetting a recorded game is not (yet) supported.");
    }

    private Void fromWrite(ObservableWriteCommandSpecification writeCommandSpecification) {
        GameState gameStateToUpdate = this.constructedState.get();
        WrittenMessage newWrittenMessage = new WrittenMessage(writeCommandSpecification.getMessage(), writeCommandSpecification.getHamster());
        gameStateToUpdate.messageList().add(newWrittenMessage);
        return null;
    }

    private Void fromInit(ObservableInitHamsterCommandSpecification initCommandSpecification) {
        GameState gameStateToUpdate = this.constructedState.get();
        HashMap<ObservableHamster, HamsterState> hamsterMapToUpdate = gameStateToUpdate.getHamsterStates();
        ObservableHamster hamsterToUpdate = initCommandSpecification.getHamster();
        HamsterState newHamsterState = new HamsterState(hamsterToUpdate.getDirection(), (Location)hamsterToUpdate.getCurrentLocation().get(), 0, 0);
        hamsterMapToUpdate.put(hamsterToUpdate, newHamsterState);
        return null;
    }

    private Void fromMove(ObservableMoveCommandSpecification moveCommandSpecification) {
        this.updateHamsterState((ObservableAbstractHamsterCommandSpecification)moveCommandSpecification, GrainDelta.NO_CHANGE);
        return null;
    }

    private Void fromTurnLeft(ObservableTurnLeftCommandSpecification turnCommandSpecification) {
        this.updateHamsterState((ObservableAbstractHamsterCommandSpecification)turnCommandSpecification, GrainDelta.NO_CHANGE);
        return null;
    }

    private Void fromPutGrain(ObservablePutGrainCommandSpecification putCommandSpecification) {
        this.updateHamsterState((ObservableAbstractHamsterCommandSpecification)putCommandSpecification, PUT_GRAIN_DELTA);
        this.updateGrainCountAt((Location)putCommandSpecification.getHamster().getCurrentLocation().get(), 1);
        return null;
    }

    private Void fromPickGrain(ObservablePickGrainCommandSpecification pickCommandSpecification) {
        this.updateHamsterState((ObservableAbstractHamsterCommandSpecification)pickCommandSpecification, PICK_GRAIN_DELTA);
        this.updateGrainCountAt((Location)pickCommandSpecification.getHamster().getCurrentLocation().get(), -1);
        return null;
    }

    private void updateGrainCountAt(Location location, int delta) {
        int[][] territory = this.constructedState.get().getTerritoryGrainCount();
        int[] nArray = territory[location.getRow()];
        int n = location.getColumn();
        nArray[n] = nArray[n] + delta;
    }

    private void updateHamsterState(ObservableAbstractHamsterCommandSpecification hamsterCommandSpecification, GrainDelta newDelta) {
        GameState gameStateToUpdate = this.constructedState.get();
        HashMap<ObservableHamster, HamsterState> hamsterMapToUpdate = gameStateToUpdate.getHamsterStates();
        ObservableHamster hamsterToUpdate = hamsterCommandSpecification.getHamster();
        HamsterState hamsterStateToUpdate = hamsterMapToUpdate.get(hamsterToUpdate);
        HamsterState newHamsterState = new HamsterState(hamsterToUpdate.getDirection(), (Location)hamsterToUpdate.getCurrentLocation().get(), hamsterStateToUpdate.getGrainCollected() + newDelta.getDeltaPickedGrains(), hamsterStateToUpdate.getGrainDropped() + newDelta.getDeltaDroppedGrains());
        hamsterMapToUpdate.put(hamsterToUpdate, newHamsterState);
    }
}

