/*
 * Decompiled with CFR 0.152.
 */
package de.hamstersimulator.objectsfirst.testframework.gamestate;

import de.hamstersimulator.objectsfirst.adapter.HamsterGameViewModel;
import de.hamstersimulator.objectsfirst.adapter.observables.ObservableLogEntry;
import de.hamstersimulator.objectsfirst.adapter.observables.ObservableTerritory;
import de.hamstersimulator.objectsfirst.adapter.observables.command.specification.ObservableCommandSpecification;
import de.hamstersimulator.objectsfirst.external.simple.game.SimpleHamsterGame;
import de.hamstersimulator.objectsfirst.testframework.HamsterGameTestEnvironment;
import de.hamstersimulator.objectsfirst.testframework.gamelog.GameLogException;
import de.hamstersimulator.objectsfirst.testframework.gamelog.GameLogFactory;
import de.hamstersimulator.objectsfirst.testframework.gamelog.datatypes.GameLog;
import de.hamstersimulator.objectsfirst.testframework.gamelog.datatypes.LogEntry;
import de.hamstersimulator.objectsfirst.testframework.gamestate.GameState;
import de.hamstersimulator.objectsfirst.testframework.gamestate.GameStateFactory;
import de.hamstersimulator.objectsfirst.testframework.ltl.LTLFormula;
import de.hamstersimulator.objectsfirst.testframework.ltl.StateCheckException;
import de.hamstersimulator.objectsfirst.utils.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;

public class RecordingHamsterGameTestEnvironment
extends HamsterGameTestEnvironment {
    private final ReadOnlyListWrapper<GameState> gameStates = new ReadOnlyListWrapper(FXCollections.observableArrayList());
    private final ListChangeListener<? super ObservableLogEntry> commandAdditionHandler = change -> {
        while (change.next()) {
            if (!change.wasAdded()) continue;
            for (ObservableLogEntry newLog : change.getAddedSubList()) {
                this.processNewLog(newLog.getCommandSpecification());
            }
        }
    };
    private final GameLogFactory gameLogFactory;
    private final Map<GameState, LogEntry> stateLogEntryLookup = new HashMap<GameState, LogEntry>();

    public RecordingHamsterGameTestEnvironment(SimpleHamsterGame targetGame) {
        super(targetGame);
        Preconditions.checkNotNull((Object)targetGame);
        HamsterGameViewModel viewModel = this.getViewModel();
        ObservableTerritory territory = viewModel.getTerritory();
        viewModel.getLog().logProperty().addListener(this.commandAdditionHandler);
        GameState initialState = GameStateFactory.newGameStateFactory().fromInitialTerritory(territory);
        this.gameStates.add((Object)initialState);
        this.gameLogFactory = new GameLogFactory(territory);
    }

    public ReadOnlyListProperty<GameState> getGameStates() {
        return this.gameStates;
    }

    private void processNewLog(ObservableCommandSpecification observableCommandSpecification) {
        assert (observableCommandSpecification != null);
        GameState nextState = GameStateFactory.newGameStateFactory().cloneFromPreviousState((GameState)this.gameStates.get(this.gameStates.size() - 1)).constructNextState(observableCommandSpecification);
        LogEntry logEntry = this.gameLogFactory.applyNextCommand(observableCommandSpecification);
        this.gameStates.add((Object)nextState);
        this.stateLogEntryLookup.put(nextState, logEntry);
    }

    public void setErrorMessage(GameState state, String errorMessage) {
        this.stateLogEntryLookup.get(state).setErrorMessage(errorMessage);
    }

    public GameLog getGameLog() {
        return this.gameLogFactory.toGameLog();
    }

    public void checkOrThrowWithLog(LTLFormula formula, GameState gameState, String message) {
        Optional<GameState> failedAtState = formula.failsAt(gameState);
        if (failedAtState.isPresent()) {
            this.setErrorMessage(failedAtState.get(), message);
            StateCheckException exception = StateCheckException.createStateCheckException(formula, gameState, message);
            throw new GameLogException(exception, this.getGameLog());
        }
    }
}

