/*
 * Decompiled with CFR 0.152.
 */
package de.hamstersimulator.objectsfirst.testframework.ltl;

import de.hamstersimulator.objectsfirst.testframework.gamestate.GameState;
import de.hamstersimulator.objectsfirst.testframework.ltl.BinaryLTLFormula;
import de.hamstersimulator.objectsfirst.testframework.ltl.LTLFormula;
import de.hamstersimulator.objectsfirst.utils.Preconditions;
import java.util.Optional;

public final class AndFormula
extends BinaryLTLFormula {
    public AndFormula(LTLFormula first, LTLFormula second, String message) {
        super(first, second, message);
    }

    public AndFormula(LTLFormula first, LTLFormula second) {
        this(first, second, "(" + first.getMessage() + ") AND (" + second.getMessage() + ")");
    }

    @Override
    public Optional<GameState> failsAt(GameState state) {
        Preconditions.checkNotNull((Object)state);
        Optional<GameState> failsAtFirst = this.getFirstOperand().failsAt(state);
        if (failsAtFirst.isPresent()) {
            return failsAtFirst;
        }
        return this.getSecondOperand().failsAt(state);
    }
}

