/*
 * Decompiled with CFR 0.152.
 */
package de.hamstersimulator.objectsfirst.testframework.ltl;

import de.hamstersimulator.objectsfirst.testframework.gamestate.GameState;
import de.hamstersimulator.objectsfirst.testframework.ltl.LTLFormula;
import de.hamstersimulator.objectsfirst.testframework.ltl.UnaryLTLFormula;
import de.hamstersimulator.objectsfirst.utils.Preconditions;
import java.util.Optional;

public final class FinallyFormula
extends UnaryLTLFormula {
    public FinallyFormula(LTLFormula operand, String message) {
        super(operand, message);
    }

    public FinallyFormula(LTLFormula operand) {
        this(operand, "FOR THIS OR ANY FUTURE STATE (" + operand.getMessage() + ")");
    }

    @Override
    public Optional<GameState> failsAt(GameState state) {
        Preconditions.checkNotNull((Object)state);
        GameState current = state;
        do {
            if (!this.getInnerFormula().appliesTo(current)) continue;
            return Optional.empty();
        } while (!(current = current.getNextGameState()).isFinalState());
        return this.getInnerFormula().failsAt(current);
    }
}

