/*
 * Decompiled with CFR 0.152.
 */
package de.hamstersimulator.objectsfirst.testframework.ltl;

import de.hamstersimulator.objectsfirst.testframework.gamestate.GameState;
import de.hamstersimulator.objectsfirst.testframework.ltl.LTLFormula;
import de.hamstersimulator.objectsfirst.utils.Preconditions;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public final class GameStatePredicate
implements LTLFormula {
    private final String message;
    private final ObservableList<GameState> allStates;
    private final ReadOnlyListWrapper<GameState> matchingStates = new ReadOnlyListWrapper((Object)this, "matchingStates", FXCollections.observableArrayList());
    private final Predicate<GameState> condition;
    private final ListChangeListener<GameState> updateMatchingStatesListener = change -> {
        while (change.next()) {
            if (change.wasRemoved() || change.wasPermutated() || change.wasUpdated() || change.wasReplaced()) {
                throw new UnsupportedOperationException("Game states should only be added, not altered in any other way.");
            }
            this.updateMatchingStates(change.getAddedSubList());
        }
    };

    public GameStatePredicate(ObservableList<GameState> gameStates, Predicate<GameState> inclusionCondition, String message) {
        Preconditions.checkNotNull(gameStates);
        Preconditions.checkNotNull(inclusionCondition);
        Preconditions.checkNotNull((Object)message);
        this.message = message;
        this.allStates = gameStates;
        this.condition = inclusionCondition;
        this.updateMatchingStates((Collection<? extends GameState>)this.allStates);
        this.allStates.addListener(this.updateMatchingStatesListener);
    }

    @Override
    public Optional<GameState> failsAt(GameState state) {
        Preconditions.checkNotNull((Object)state);
        Preconditions.checkArgument((boolean)this.allStates.contains((Object)state));
        if (this.matchingStates.contains((Object)state)) {
            return Optional.empty();
        }
        return Optional.of(state);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public ReadOnlyListProperty<GameState> getMatchingStates() {
        return this.matchingStates;
    }

    private void updateMatchingStates(Collection<? extends GameState> statesToCheck) {
        for (GameState gameState : statesToCheck) {
            if (!this.condition.test(gameState)) continue;
            this.matchingStates.add((Object)gameState);
        }
    }
}

