/*
 * Decompiled with CFR 0.152.
 */
package de.hamstersimulator.objectsfirst.testframework.ltl;

import de.hamstersimulator.objectsfirst.testframework.gamestate.GameState;
import de.hamstersimulator.objectsfirst.testframework.ltl.BinaryLTLFormula;
import de.hamstersimulator.objectsfirst.testframework.ltl.LTLFormula;
import de.hamstersimulator.objectsfirst.utils.Preconditions;
import java.util.Optional;

public final class ImpliesFormula
extends BinaryLTLFormula {
    public ImpliesFormula(LTLFormula first, LTLFormula second, String message) {
        super(first, second, message);
    }

    public ImpliesFormula(LTLFormula first, LTLFormula second) {
        this(first, second, "(" + first.getMessage() + ") ==> (" + second.getMessage() + ")");
    }

    @Override
    public Optional<GameState> failsAt(GameState state) {
        Preconditions.checkNotNull((Object)state);
        Optional<GameState> failsAtSecond = this.getSecondOperand().failsAt(state);
        if (failsAtSecond.isPresent() && this.getFirstOperand().appliesTo(state)) {
            return failsAtSecond;
        }
        return Optional.empty();
    }
}

