/*
 * Decompiled with CFR 0.152.
 */
package de.hamstersimulator.objectsfirst.testframework.ltl;

import de.hamstersimulator.objectsfirst.testframework.gamestate.GameState;
import de.hamstersimulator.objectsfirst.testframework.ltl.BinaryLTLFormula;
import de.hamstersimulator.objectsfirst.testframework.ltl.LTLFormula;
import de.hamstersimulator.objectsfirst.utils.Preconditions;
import java.util.Optional;

public final class ReleaseFormula
extends BinaryLTLFormula {
    public ReleaseFormula(LTLFormula first, LTLFormula second, String message) {
        super(first, second, message);
    }

    public ReleaseFormula(LTLFormula first, LTLFormula second) {
        this(first, second, "(" + second.getMessage() + ") MUST ALWAYS APPLY UNTIL (" + first.getMessage() + ")");
    }

    @Override
    public Optional<GameState> failsAt(GameState state) {
        Preconditions.checkNotNull((Object)state);
        GameState current = state;
        while (this.getSecondOperand().appliesTo(current)) {
            if (current.isFinalState()) {
                return Optional.empty();
            }
            if (this.getFirstOperand().appliesTo(current)) {
                return Optional.empty();
            }
            current = current.getNextGameState();
        }
        return this.getSecondOperand().failsAt(state);
    }
}

