/*
 * Decompiled with CFR 0.152.
 */
package de.hamstersimulator.objectsfirst.testframework.ltl;

import de.hamstersimulator.objectsfirst.testframework.gamestate.GameState;
import de.hamstersimulator.objectsfirst.testframework.ltl.LTLFormula;
import de.hamstersimulator.objectsfirst.utils.Preconditions;

public final class StateCheckException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final LTLFormula formula;
    private final GameState gameState;

    private StateCheckException(String message, LTLFormula failedFormula, GameState stateFailedIn) {
        super(message);
        Preconditions.checkNotNull((Object)message);
        Preconditions.checkArgument((!message.isBlank() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)failedFormula);
        Preconditions.checkNotNull((Object)stateFailedIn);
        this.formula = failedFormula;
        this.gameState = stateFailedIn;
    }

    public LTLFormula getFormula() {
        return this.formula;
    }

    public GameState getGameState() {
        return this.gameState;
    }

    public static void checkOrThrow(LTLFormula formula, GameState gameState, String message) {
        if (!formula.appliesTo(gameState)) {
            StateCheckException exception = StateCheckException.createStateCheckException(formula, gameState, message);
            throw exception;
        }
    }

    public static StateCheckException createStateCheckException(LTLFormula formula, GameState gameState, String message) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("The executed hamster game reached an unexpected state.\n");
        stringBuilder.append("The reason given is:");
        stringBuilder.append(message);
        stringBuilder.append("\n\n");
        stringBuilder.append("Underlying logic:");
        stringBuilder.append(formula.getMessage());
        stringBuilder.append("\n\n");
        return new StateCheckException(stringBuilder.toString(), formula, gameState);
    }
}

