/*
 * Decompiled with CFR 0.152.
 */
package de.hamstersimulator.objectsfirst.testframework.ltl;

import de.hamstersimulator.objectsfirst.testframework.gamestate.GameState;
import de.hamstersimulator.objectsfirst.testframework.ltl.BinaryLTLFormula;
import de.hamstersimulator.objectsfirst.testframework.ltl.LTLFormula;
import de.hamstersimulator.objectsfirst.utils.Preconditions;
import java.util.Optional;

public final class UntilFormula
extends BinaryLTLFormula {
    public UntilFormula(LTLFormula first, LTLFormula second, String message) {
        super(first, second, message);
    }

    public UntilFormula(LTLFormula first, LTLFormula second) {
        this(first, second, "(" + first.getMessage() + ") UNTIL (" + second.getMessage() + ")");
    }

    @Override
    public Optional<GameState> failsAt(GameState state) {
        Preconditions.checkNotNull((Object)state);
        GameState current = state;
        Optional<GameState> failsAtCurrent = this.getSecondOperand().failsAt(current);
        while (failsAtCurrent.isPresent()) {
            if (current.isFinalState()) {
                return failsAtCurrent;
            }
            if (!this.getFirstOperand().appliesTo(current)) {
                return failsAtCurrent;
            }
            current = current.getNextGameState();
            failsAtCurrent = this.getSecondOperand().failsAt(current);
        }
        return Optional.empty();
    }
}

