/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.ipc.javabridge;

import de.julielab.ipc.javabridge.BinaryReader;
import de.julielab.ipc.javabridge.ErrorStreamConsumer;
import de.julielab.ipc.javabridge.GenericCommunicator;
import de.julielab.ipc.javabridge.Options;
import de.julielab.ipc.javabridge.Reader;
import de.julielab.ipc.javabridge.StringReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdioBridge<O> {
    private static final Logger log = LoggerFactory.getLogger(StdioBridge.class);
    private String[] arguments;
    private Process process;
    private GenericCommunicator communicator;
    private ErrorStreamConsumer errorStreamConsumer;
    private Options<O> options;

    public StdioBridge(Options<O> options, String ... arguments) {
        this.options = options;
        if (arguments.length == 0) {
            throw new IllegalArgumentException("No external program to run has been specified.");
        }
        this.arguments = arguments;
    }

    public void start() throws IOException {
        Reader r;
        String[] command = new String[this.arguments.length + 1];
        command[0] = this.options.getExecutable();
        System.arraycopy(this.arguments, 0, command, 1, this.arguments.length);
        ProcessBuilder builder = new ProcessBuilder(command);
        this.process = builder.start();
        this.errorStreamConsumer = new ErrorStreamConsumer(this.process.getErrorStream(), this.options.getTerminationSignalFromErrorStream(), Thread.currentThread());
        this.errorStreamConsumer.start();
        log.debug("Started process with arguments {}", (Object)Arrays.toString(this.arguments));
        BufferedInputStream bis = new BufferedInputStream(this.process.getInputStream());
        BufferedOutputStream bos = new BufferedOutputStream(this.process.getOutputStream());
        boolean isStringResponse = this.options.getResultType().equals(String.class);
        if (isStringResponse) {
            r = new StringReader((InputStream)bis, this.options.getResultLineIndicator(), this.options.getExternalProgramReadySignal());
        } else if (this.options.getResultType().equals(byte[].class)) {
            r = new BinaryReader((InputStream)bis, this.options.getExternalProgramReadySignal(), this.options.isGzipReceivedData());
        } else {
            throw new IllegalArgumentException("The result type must be String or byte[] but was " + this.options.getResultType());
        }
        this.communicator = new GenericCommunicator<String>(r, bos, isStringResponse ? this.options.getMultilineResponseDelimiter() : null, this.options.isGzipSentData());
    }

    public void stop() throws InterruptedException, IOException {
        if (this.options.getExternalProgramTerminationSignal() != null) {
            this.communicator.send(this.options.getExternalProgramTerminationSignal().getBytes());
            log.info("Sent the external process termination signal \"{}\" and waiting for the process to end.", (Object)this.options.getExternalProgramTerminationSignal());
            this.process.waitFor();
        }
        if (this.communicator != null) {
            this.communicator.close();
        }
        if (this.errorStreamConsumer != null) {
            this.errorStreamConsumer.close();
        }
        if (this.process != null) {
            if (this.process.isAlive()) {
                this.process.destroy();
                this.process.waitFor();
            }
            int exitValue = this.process.exitValue();
            log.info("Process exited with exit value {}. The run arguments was: {}", (Object)exitValue, (Object)Arrays.toString(this.arguments));
        }
    }

    public void send(byte[] data) {
        if (this.communicator == null) {
            throw new IllegalStateException("The internal Python-Java communicator has not been initialized. Did you forget to execute start()?");
        }
        this.communicator.send(data);
    }

    public void send(String data) {
        this.send(data.getBytes(StandardCharsets.UTF_8));
    }

    public Stream<O> receive() throws InterruptedException {
        List lines = this.communicator.receive();
        if (this.options.getResultReshaper() != null) {
            Function<O, O> transformator = this.options.getResultReshaper();
            return lines.stream().map(transformator::apply);
        }
        return lines.stream();
    }

    public Stream<O> sendAndReceive(byte[] data) throws InterruptedException {
        long sendandreceivetime = System.currentTimeMillis();
        long time = System.currentTimeMillis();
        this.send(data);
        time = System.currentTimeMillis() - time;
        log.trace("Sending data took {}ms", (Object)time);
        time = System.currentTimeMillis();
        Stream<O> receivedData = this.receive();
        time = System.currentTimeMillis() - time;
        log.trace("Receiving data took {}ms", (Object)time);
        sendandreceivetime = System.currentTimeMillis() - sendandreceivetime;
        log.trace("sendAndReceive took {}ms", (Object)sendandreceivetime);
        return receivedData;
    }

    public Stream<O> sendAndReceive(String data) throws InterruptedException {
        return this.sendAndReceive(data.getBytes(StandardCharsets.UTF_8));
    }
}

