/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.db;

import de.julielab.xmlData.dataBase.DataBaseConnector;
import java.io.FileNotFoundException;
import java.util.Optional;
import org.apache.uima.UimaContext;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBReaderBase
extends JCasCollectionReader_ImplBase {
    public static final String PARAM_TABLE = "Table";
    public static final String PARAM_COSTOSYS_CONFIG_NAME = "CostosysConfigFile";
    public static final String PARAM_BATCH_SIZE = "BatchSize";
    private static final Logger log = LoggerFactory.getLogger(DBReaderBase.class);
    private static final String DEFAULT_BATCH_SIZE = "50";
    @ConfigurationParameter(name="BatchSize", defaultValue={"50"}, mandatory=false)
    protected int batchSize;
    @ConfigurationParameter(name="DBDriver", mandatory=false, description="Currently unused because the Hikari JDBC library should recognize the correct driver. However, there seem to be cases where this doesn't work (HSQLDB). So we keep the parameter for later. When this issue comes up, the driver would have to be set manually. This isn't done right now.")
    protected String driver;
    @ConfigurationParameter(name="Table", description="The data or subset database table to read from. The name will be resolved against the active Postgres schema defined in the CoStoSys configuration file.However, if the name contains a schema qualification (i.e. 'schemaname.tablename), the configuration file will be ignored in this point.")
    protected String tableName;
    @ConfigurationParameter(name="SelectionOrder", defaultValue={""}, mandatory=false, description="WARNING: Potential SQL injection vulnerability. Do not let unknown users interact with your database with this component. An SQL ORDER clause specifying in which order the documents in the target database table should be processed. Only the clause itself must be specified, the ORDER keyword is automatically added.")
    protected String selectionOrder;
    @ConfigurationParameter(name="WhereCondition", mandatory=false, description="WARNING: Potential SQL injection vulnerability. Do not let unknown users interact with your database with this component. Only used when reading data tables directly. No effect when the 'tableName' parameter specifies a subset table. The parameter value should be an SQL WHERE clause restricting the documents to be read. Only the clause itself must be specified, the WHERE keyword is added automatically.")
    protected String whereCondition;
    @ConfigurationParameter(name="Limit", mandatory=false)
    protected Integer limitParameter;
    protected volatile int numberFetchedDocIDs = 0;
    protected boolean joinTables = false;
    protected DataBaseConnector dbc;
    protected boolean hasNext;
    protected int totalDocumentCount;
    protected int processedDocuments = 0;
    @ConfigurationParameter(name="CostosysConfigFile", mandatory=true, description="File path or classpath resource location to the CoStoSys XML configuration. This configuration must specify the table schema of the table referred to by the 'Table' parameter as active table schema. The active table schema is always the schema of the data table that is either queried directly for documents or, if 'tableName' points to a subset table, indirectly through the subset table. Make also sure that the active database connection in the configuration points to the correct database.")
    protected String costosysConfig;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.driver = (String)this.getConfigParameterValue("DBDriver");
        this.batchSize = Optional.ofNullable((Integer)this.getConfigParameterValue(PARAM_BATCH_SIZE)).orElse(Integer.parseInt(DEFAULT_BATCH_SIZE));
        this.tableName = (String)this.getConfigParameterValue(PARAM_TABLE);
        this.selectionOrder = (String)this.getConfigParameterValue("SelectionOrder");
        this.whereCondition = (String)this.getConfigParameterValue("WhereCondition");
        this.limitParameter = (Integer)this.getConfigParameterValue("Limit");
        this.costosysConfig = (String)this.getConfigParameterValue(PARAM_COSTOSYS_CONFIG_NAME);
        this.checkParameters();
        try {
            if (this.dbc == null) {
                this.dbc = new DataBaseConnector(this.costosysConfig);
            }
            this.dbc.setQueryBatchSize(this.batchSize);
            this.checkTableExists();
            this.logConfigurationState();
        }
        catch (FileNotFoundException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    private void checkTableExists() throws ResourceInitializationException {
        if (!this.dbc.withConnectionQueryBoolean(c -> c.tableExists(this.tableName))) {
            throw new ResourceInitializationException((Throwable)new IllegalArgumentException("The configured table \"" + this.tableName + "\" does not exist."));
        }
    }

    private void checkParameters() throws ResourceInitializationException {
        if (this.tableName == null || this.tableName.length() == 0) {
            throw new ResourceInitializationException("config_setting_absent", new Object[]{PARAM_TABLE});
        }
        if (this.costosysConfig == null || this.costosysConfig.length() == 0) {
            throw new ResourceInitializationException("config_setting_absent", new Object[]{PARAM_COSTOSYS_CONFIG_NAME});
        }
    }

    private void logConfigurationState() {
        log.info("BatchSize is set to {}.", (Object)this.batchSize);
    }
}

