/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.db;

import de.julielab.jcore.reader.db.DBReaderBase;
import de.julielab.xmlData.dataBase.CoStoSysConnection;
import de.julielab.xmlData.dataBase.DataBaseConnector;
import de.julielab.xmlData.dataBase.util.CoStoSysSQLRuntimeException;
import de.julielab.xmlData.dataBase.util.TableSchemaMismatchException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.uima.UimaContext;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBSubsetReader
extends DBReaderBase {
    public static final String PARAM_ADDITIONAL_TABLES = "AdditionalTables";
    public static final String PARAM_RESET_TABLE = "ResetTable";
    public static final String PARAM_ADDITONAL_TABLES_STORAGE_PG_SCHEMA = "AdditionalTablesPostgresSchema";
    static final String DESC_ADDITIONAL_TABLES = "An array of table names or a string in the form of a qualified Java class, i.e. a dot-separated path. In the latter case, an existing table is searched for by converting the dots to underscores. A specific Postgres schema can be specified by prepending the Java-style path with a schema name followed by a colon, e.g. 'myschema:de.julielab.jcore.types.Token'. By default, the table names will be resolved against the active data postgres schema configured in the CoStoSys configuration file. If a name is already schema qualified, i.e. contains a dot or a colon, the active data schema will be ignored for this table. When reading documents from the document data table, the additional tables will be joined onto the data table using the primary keys of the queried documents. Using the table schema for the additional documents defined by the 'AdditionalTableSchema' parameter, the columns that are marked as 'retrieve=true' in the table schema, are returned together with the main document data. This mechanism is most prominently used to retrieve annotation table data together with the original document text in XMI format for the JeDIS system.";
    static final String DESC_ADDITIONAL_TABLE_SCHEMAS = "The table schemas that corresponds to the additional tables given with the 'AdditionalTables' parameter. If only one schema name is given, that schema must apply to all additional tables.";
    private static final Logger log = LoggerFactory.getLogger(DBSubsetReader.class);
    @ConfigurationParameter(name="ResetTable", defaultValue={"false"}, mandatory=false, description="If set to true and the parameter 'Table' is set to a subset table, the subset table will be reset atthe initialization of the reader to be ready for processing of the whole subset. Do not use when multiple readers read the same subset table.")
    protected Boolean resetTable;
    @ConfigurationParameter(name="FetchIdsProactively", defaultValue={"true"}, description="If set to true and when reading from a subset table, batches of document IDs will be retrieved in a background thread while the previous batch is already in process. This is meant to minimize waiting time for the database. Deactivate this feature if you encounter issues with databaase connections.")
    protected Boolean fetchIdsProactively;
    @ConfigurationParameter(name="AdditionalTables", mandatory=false, description="An array of table names or a string in the form of a qualified Java class, i.e. a dot-separated path. In the latter case, an existing table is searched for by converting the dots to underscores. A specific Postgres schema can be specified by prepending the Java-style path with a schema name followed by a colon, e.g. 'myschema:de.julielab.jcore.types.Token'. By default, the table names will be resolved against the active data postgres schema configured in the CoStoSys configuration file. If a name is already schema qualified, i.e. contains a dot or a colon, the active data schema will be ignored for this table. When reading documents from the document data table, the additional tables will be joined onto the data table using the primary keys of the queried documents. Using the table schema for the additional documents defined by the 'AdditionalTableSchema' parameter, the columns that are marked as 'retrieve=true' in the table schema, are returned together with the main document data. This mechanism is most prominently used to retrieve annotation table data together with the original document text in XMI format for the JeDIS system.")
    protected String[] additionalTableNames;
    @ConfigurationParameter(name="AdditionalTableSchemas", mandatory=false, description="The table schemas that corresponds to the additional tables given with the 'AdditionalTables' parameter. If only one schema name is given, that schema must apply to all additional tables.")
    protected String[] additionalTableSchemas;
    protected String hostName;
    protected String pid;
    protected String dataTable;
    protected Boolean readDataTable = false;
    protected String[] tables;
    protected String[] schemas;
    @ConfigurationParameter(name="AdditionalTablesPostgresSchema", mandatory=false, description="This optional parameter specifies the Postgres schema in which the additional tables to read are searched by default. If omitted, the active data schema from the CoStoSys configuration is assumed. The default can be overwritten for individual types. For details, see the description of the 'AdditionalTables' parameter.")
    private String additionalTablesPGSchema;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        block22: {
            super.initialize(context);
            this.hostName = this.getHostName();
            this.pid = this.getPID();
            this.resetTable = Optional.ofNullable((Boolean)this.getConfigParameterValue(PARAM_RESET_TABLE)).orElse(false);
            this.fetchIdsProactively = Optional.ofNullable((Boolean)this.getConfigParameterValue("FetchIdsProactively")).orElse(true);
            this.additionalTableNames = (String[])this.getConfigParameterValue(PARAM_ADDITIONAL_TABLES);
            this.additionalTableSchemas = (String[])context.getConfigParameterValue("AdditionalTableSchemas");
            this.additionalTablesPGSchema = Optional.ofNullable((String)this.getConfigParameterValue(PARAM_ADDITONAL_TABLES_STORAGE_PG_SCHEMA)).orElse(this.dbc.getActiveDataPGSchema());
            this.checkAdditionalTableParameters(this.additionalTableNames, this.additionalTableSchemas);
            this.determineDataTable();
            try {
                if (this.readDataTable.booleanValue()) {
                    if (this.additionalTableNames != null) {
                        throw new NotImplementedException("At the moment multiple tables can only be joined if the data table is referenced by a subset, for which the name has to be given in the Table parameter.");
                    }
                    this.dbc.checkTableDefinition(this.tableName);
                    Integer tableRows = this.dbc.withConnectionQueryInteger(c -> c.countRowsOfDataTable(this.tableName, this.whereCondition));
                    this.totalDocumentCount = this.limitParameter != null ? Math.min(tableRows, this.limitParameter) : tableRows;
                    this.hasNext = !this.dbc.withConnectionQueryBoolean(c -> c.isEmpty(this.tableName));
                    this.tables = new String[]{this.tableName};
                    this.schemas = new String[]{this.dbc.getActiveTableSchema()};
                    break block22;
                }
                if (this.batchSize == 0) {
                    log.warn("Batch size of retrieved documents is set to 0. Nothing will be returned.");
                }
                try (CoStoSysConnection conn = this.dbc.obtainOrReserveConnection();){
                    if (this.resetTable.booleanValue()) {
                        this.dbc.resetSubset(this.tableName);
                    }
                    Integer unprocessedDocs = this.dbc.countUnprocessed(this.tableName);
                    this.totalDocumentCount = this.limitParameter != null ? Math.min(unprocessedDocs, this.limitParameter) : unprocessedDocs;
                    this.dataTable = this.dbc.getReferencedTable(this.tableName);
                    this.hasNext = this.dbc.hasUnfetchedRows(this.tableName);
                    log.debug("Checking if the subset table \"{}\" has unfetched rows. Result: {}", (Object)this.tableName, (Object)this.hasNext);
                    if (this.additionalTableNames != null && this.additionalTableNames.length > 0) {
                        log.debug("Additional tables were given: {}", (Object)Arrays.toString(this.additionalTableNames));
                        log.debug("Preparing for reading from multiple tables.");
                        this.joinTables = true;
                        this.dbc.checkTableSchemaCompatibility(this.dbc.getActiveTableSchema(), this.additionalTableSchemas);
                        ImmutablePair<Integer, String[]> additionalTableNumAndNames = this.checkAndAdjustAdditionalTables(this.dbc, this.dataTable, this.additionalTableNames);
                        int numAdditionalTables = (Integer)additionalTableNumAndNames.getLeft();
                        this.tables = (String[])additionalTableNumAndNames.getRight();
                        this.schemas = new String[numAdditionalTables + 1];
                        if (this.additionalTableSchemas.length == 1) {
                            Arrays.fill(this.schemas, this.additionalTableSchemas[0]);
                        } else {
                            System.arraycopy(this.additionalTableSchemas, 0, this.schemas, 1, this.additionalTableSchemas.length);
                        }
                        this.schemas[0] = this.dbc.getActiveTableSchema();
                    } else {
                        log.debug("No additional tables were given, reading data solely from table {}", (Object)this.dataTable);
                        this.tables = new String[]{this.dataTable};
                        this.schemas = new String[1];
                        this.schemas[0] = this.dbc.getActiveTableSchema();
                    }
                    this.dbc.checkTableDefinition(this.dataTable, this.schemas[0]);
                }
            }
            catch (TableSchemaMismatchException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        }
        this.logConfigurationState();
    }

    private void logConfigurationState() {
        log.info("Subset table {} will be reset upon pipeline start: {}", (Object)this.tableName, (Object)this.resetTable);
        if (log.isInfoEnabled()) {
            log.info("Names of additional tables to join: {}", (Object)StringUtils.join((Object[])this.additionalTableNames, (String)", "));
        }
        log.info("TableName is: \"{}\"; referenced data table name is: \"{}\"", (Object)this.tableName, (Object)this.dataTable);
        log.info("List of all tables to read: {}", (Object[])this.tables);
        log.info("List of the table schemas: {}", (Object[])this.schemas);
    }

    protected List<Map<String, Object>> getAllRetrievedColumns() {
        ArrayList fields = new ArrayList();
        Pair numColumnsAndFields = this.dbc.getNumColumnsAndFields(this.joinTables, this.schemas);
        return ((List)numColumnsAndFields.getRight()).stream().map(HashMap::new).collect(Collectors.toList());
    }

    private String getPID() {
        String id = ManagementFactory.getRuntimeMXBean().getName();
        return id.substring(0, id.indexOf(64));
    }

    private String getHostName() {
        String hostName;
        try {
            InetAddress address = InetAddress.getLocalHost();
            hostName = address.getHostName();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
        return hostName;
    }

    private void determineDataTable() throws ResourceInitializationException {
        try {
            this.readDataTable = this.dbc.withConnectionQueryBoolean(c -> c.isDataTable(this.tableName));
            this.dataTable = this.dbc.withConnectionQueryString(c -> c.getNextOrThisDataTable(this.tableName));
            if (this.readDataTable.booleanValue()) {
                log.info("The table \"{}\" is a data table, documents will not be marked to be in process and no synchronization of multiple DB readers will happen.", (Object)this.tableName);
            }
        }
        catch (CoStoSysSQLRuntimeException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    protected void checkAdditionalTableParameters(String[] additionalTableNames, String[] additionalTableSchemas) throws ResourceInitializationException {
        int i;
        if (additionalTableNames != null && additionalTableNames.length != 0 && additionalTableSchemas == null) {
            throw new ResourceInitializationException((Throwable)new IllegalArgumentException("If multiple tables will be joined the table schema for the additional tables (besides the base document table which should be configured using the database connector configuration) must be specified."));
        }
        ArrayList<Integer> nullindexes = new ArrayList<Integer>();
        for (i = 0; additionalTableNames != null && i < additionalTableNames.length; ++i) {
            String additionalTableName = additionalTableNames[i];
            if (!StringUtils.isBlank((CharSequence)additionalTableName)) continue;
            nullindexes.add(i);
        }
        if (!nullindexes.isEmpty()) {
            throw new ResourceInitializationException((Throwable)new IllegalArgumentException("The following 0-based array indexes of the passed additional tables were null or empty: " + nullindexes));
        }
        nullindexes.clear();
        for (i = 0; additionalTableSchemas != null && i < additionalTableSchemas.length; ++i) {
            String additionalTableSchemaName = additionalTableSchemas[i];
            if (!StringUtils.isBlank((CharSequence)additionalTableSchemaName)) continue;
            nullindexes.add(i);
        }
        if (!nullindexes.isEmpty()) {
            throw new ResourceInitializationException((Throwable)new IllegalArgumentException("The following 0-based array indexes of the passed additional table schemas were null or empty: " + nullindexes));
        }
    }

    protected ImmutablePair<Integer, String[]> checkAndAdjustAdditionalTables(DataBaseConnector dbc, String dataTable, String[] additionalTableNames) {
        ArrayList<String> foundTables = new ArrayList<String>();
        foundTables.add(dataTable);
        for (int i = 0; i < additionalTableNames.length; ++i) {
            String resultTableName = null;
            String rawName = additionalTableNames[i];
            if (rawName.contains(":")) {
                int colonIndex = rawName.indexOf(58);
                if (colonIndex == rawName.length() - 1) {
                    throw new IllegalArgumentException("The table name \"" + rawName + "\" is invalid. Consult the description of the " + PARAM_ADDITIONAL_TABLES + " parameter for more information.");
                }
                String schema = rawName.substring(0, colonIndex);
                String rawTableName = rawName.substring(colonIndex + 1);
                String tableName = rawTableName.replaceAll("\\.", "_");
                resultTableName = schema + "." + tableName;
            } else if (dbc.tableExists(rawName)) {
                resultTableName = rawName;
            } else if (dbc.tableExists(this.additionalTablesPGSchema + "." + rawName.replaceAll("\\.", "_"))) {
                resultTableName = this.additionalTablesPGSchema + "." + rawName.replaceAll("\\.", "_");
            }
            if (null == resultTableName) {
                throw new IllegalArgumentException("The table " + additionalTableNames[i] + " does not exist.");
            }
            foundTables.add(resultTableName);
        }
        String[] tables = foundTables.toArray(new String[foundTables.size()]);
        int numAdditionalTables = tables.length - 1;
        return new ImmutablePair((Object)numAdditionalTables, (Object)tables);
    }
}

